/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (PatternTools_CURRENT_HEADER)
	#error Inclusion recursive du header PatternTools.
#endif
#define	PatternTools_CURRENT_HEADER

#if ! defined (PatternTools_HEADER_INCLUDED)
#define	PatternTools_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"gt_limit.h"
#include	"UndoCell.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

enum
{
	PatternTools_SCOPE_TRACK = 0,
	PatternTools_SCOPE_PATTERN,
	PatternTools_SCOPE_PRESET,

	PatternTools_NBR_SCOPES
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	int		pattern;
	int		track [Pattern_NBR_TYPES];
	UBYTE		valid [Pattern_NBR_TYPES] [8];
	UBYTE		mask_flag [2] [Pattern_NBR_TYPES] [8];	/* Mask on / Replace by */
	UBYTE		mask_value [2] [Pattern_NBR_TYPES] [8];	/* Mask on / Replace by */
	int		start;
	int		end;
} PatternTools_BLOCK_INFO;



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class PatternTools
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static const char	*const SCOPE_NAME_0 [PatternTools_NBR_SCOPES];



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
PatternTools (void);
PatternTools (const PatternTools &other);
~PatternTools (void);
signed int	check_ok (void) const;
void		self_display (void) const;
void	operator = (const PatternTools &other);

/*--------------------------------------------------------------------------*/
/*      Etats                                                               */
/*--------------------------------------------------------------------------*/

void	check_block (void);
void	set_block_start (int pattern, int line, int track_type, int track);
void	set_block_end (int pattern, int line, int track_type, int track);
void	set_block_single_line (int pattern, int line, int track_type, int track);
void	set_scope (int scope);
void	set_all_track_type_flag (bool flag);
void	set_song_flag (bool flag);
void	set_tracks_on_flag (bool flag);
void	set_transp_flag (bool flag);
void	set_use_mask_flag (bool flag);
void	set_filter_flag (int track_type, int pos, int len, bool flag);
void	set_mask_flag (int track_type, int pos, int pos_2, int len, int mask, bool flag);
void	set_mask_value (int track_type, int pos, int pos_2, int mask, int value);

PatternTools_BLOCK_INFO	get_current_selection (void);
int	get_block_height (void);
int	get_scope (void);
bool	get_all_track_type_flag (void);
bool	get_song_flag (void);
bool	get_tracks_on_flag (void);
bool	get_transp_flag (void);
bool	get_use_mask_flag (void);
bool	get_full_clipboard_flag (void);
bool	get_filter_flag (int track_type, int pos, int len);

/*--------------------------------------------------------------------------*/
/*      Actions                                                             */
/*--------------------------------------------------------------------------*/

signed int	copy_block (void);
signed int	paste_block (int pattern, int line, int track_type, int track, UndoCell **undo_ptr_ptr);
signed int	insert_block (int pattern, int line, int track_type, int track, UndoCell **undo_ptr_ptr);

signed int	paste_selection (int pattern, int line, int track_type, int track, UndoCell **undo_ptr_ptr);
signed int	insert_selection (int pattern, int line, int track_type, int track, UndoCell **undo_ptr_ptr);
signed int	clear_selection (int track_type, UndoCell **undo_ptr_ptr);
signed int	delete_selection (int track_type, UndoCell **undo_ptr_ptr);
signed int	transpose_selection (int track_type, UndoCell **undo_ptr_ptr, int transpose);
signed int	swap_selection (int pattern, int line, int track_type, int track, UndoCell **undo_ptr_ptr);
signed int	filter_selection (UndoCell **undo_ptr_ptr);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

int	clip_block (int pattern, int line);
void	select_tracks (bool track_selection [Pattern_NBR_TYPES] [GTK_NBRTRACKS_MAXI], int track_type);
void	copy_note (int dest_pat, int track_type, int dest_track, int dest_line, int src_pat, int src_track, int src_line);
void	clear_note (int track_type, int pattern, int track, int line);
void	transpose_note (int track_type, int pattern, int track, int line, int transpose);

signed int	paste_selection_1_pat (int pattern, int line, int track_type, int track, UndoCell **undo_ptr_ptr);
signed int	insert_selection_1_pat (int pattern, int line, int track_type, int track, UndoCell **undo_ptr_ptr);
signed int	clear_selection_1_pat (int pattern, int track_type, UndoCell **undo_ptr_ptr);
signed int	delete_selection_1_pat (int pattern, int track_type, UndoCell **undo_ptr_ptr);
signed int	transpose_selection_1_pat (int pattern, int track_type, UndoCell **undo_ptr_ptr, int transpose);
signed int	move_selection_1_pat (int pattern, int line, int track_type, UndoCell **undo_ptr_ptr);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

PatternTools_BLOCK_INFO	_selection;
int		_scope;						/* Precise le lieu des operations */
bool		_all_track_type_flag;	/* true: tous les types de pistes sont concernes. */
bool		_song_flag;					/* true: on repete l'operation sur tous les patterns de la song. */
bool		_tracks_on_flag;			/* true: on n'opere que sur les pistes active. */
bool		_transp_flag;				/* true: on n'ecrit que les donnees source non-nulles. */
bool		_use_mask_flag;			/* true: on utilise le systeme de masques */



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		operator == (const PatternTools &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PatternTools_CURRENT_HEADER
