/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*

- L'utilisation doit toujours commencer par init et finir par restore.
- set_config doit etre fait avant d'utiliser start_replay. Il peut etre
ensuite reappele, mais toujours en mode stop.
- Toujours etre en mode play pour utiliser set_new_frame.
- connect et disconnect sont independant de l'etat de replay
- On peut tout arreter d'un coup en faisant un restore
- si on est deja connecte, un appel a connect ne fait rien. Idem pour
disconnect.
- Les settings de latency sont independants du fait que le driver soit
initialise ou non.



Schemas d'utilisation classiques:

init
connect
set_config
start_replay
set_new_frame
restore

init
set_config
start_replay
set_new_frame
connect
set_new_frame
stop_replay
disconnect
start_replay
set_new_frame
restore

*/



#if defined (SoundDriver_CURRENT_HEADER)
	#error Inclusion recursive du header SoundDriver.
#endif
#define	SoundDriver_CURRENT_HEADER

#if ! defined (SoundDriver_HEADER_INCLUDED)
#define	SoundDriver_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	long		sample_freq;		// -1 = defaut
	int		nbr_buffers;		// -1 = defaut
	int		nbr_out;				// -1 = defaut
	int		nbr_in;				// -1 = defaut
	int		*out_stereo_ptr;	// -1 = defaut. Minimum 2 cases
	int		*in_stereo_ptr;	// -1 = defaut. Minimum 2 cases
} SoundDriver_CONFIG;



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class	Mutex;		// Ca permet d'eviter d'inclure Mutex.h dans ce header.

class SoundDriver
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
	enum
	{
		MAX_LATENCY = 9999
	};



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
SoundDriver (void);
~SoundDriver (void);
signed int	check_ok (void) const;
void		self_display (void) const;

signed int	init (void *param_ptr);
signed int	restore (void);
signed int	set_config (SoundDriver_CONFIG *config_ptr);
signed int	get_config (SoundDriver_CONFIG *config_ptr);
signed int	start_replay (void);
signed int	stop_replay (void);
signed int	set_new_frame (long frame_length);
signed int	set_data (float *out_buffer_ptr [], float *out_clip_ptr);
signed int	get_data (float *in_buffer_ptr []);
signed int	is_playing (void);
signed int	disconnect (void);
signed int	connect (void);
signed int	is_connected (void);
signed int	get_message (char *text_0, long max_len);
signed int	get_latency (void);
signed int	set_latency (int t);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

signed int	(cdecl *_init) (void *param_ptr);
signed int	(cdecl *_restore) (void);
signed int	(cdecl *_set_config) (SoundDriver_CONFIG *config_ptr);
signed int	(cdecl *_get_config) (SoundDriver_CONFIG *config_ptr);
signed int	(cdecl *_start_replay) (void);
signed int	(cdecl *_stop_replay) (void);
signed int	(cdecl *_set_new_frame) (long frame_length);
signed int	(cdecl *_set_data) (float *out_buffer_ptr [], float *out_clip_ptr);
signed int	(cdecl *_get_data) (float *in_buffer_ptr []);
signed int	(cdecl *_is_playing) (void);
signed int	(cdecl *_disconnect) (void);
signed int	(cdecl *_connect) (void);
signed int	(cdecl *_is_connected) (void);
signed int	(cdecl *_get_message) (char *text_0, long max_len);
signed int	(cdecl *_get_latency) (void);
signed int	(cdecl *_set_latency) (int t);



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void	print_message (void);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
char		_message_buffer_0 [1023+1];
Mutex		*_mutex_ptr;	// Permet de n'autoriser qu'un seul acces a la fois aux driver



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
SoundDriver (const SoundDriver &other);
void		operator = (const SoundDriver &other);
int		operator == (const SoundDriver &other) const;
int		operator != (const SoundDriver &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SoundDriver_CURRENT_HEADER
