/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base.h"
#include	"base_ct.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"SplEdVumetres.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	SplEdVumetres::redraw (void)
{
	RSC_display_object (RSC_OBJ_SE_VU);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	SplEdVumetres::refresh (void)
{

	/*** A faire ***/

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	SplEdVumetres::manage (int sel_object, int sel_elder)
{
	switch (sel_object)
	{

	/* Vu-metre gauche */
	case	RSC_OBJ_SE_VU_LEFT_DISP:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Valeur vu-metre gauche */
	case	RSC_OBJ_SE_VU_LEFT_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Vu-metre droit */
	case	RSC_OBJ_SE_VU_RIGHT_DISP:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Valeur vu-metre droit */
	case	RSC_OBJ_SE_VU_RIGHT_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	}
}



int	SplEdVumetres::get_width (void)
{
	return (RSC_get_width (RSC_OBJ_SE_VU));
}



int	SplEdVumetres::get_height (void)
{
	return (RSC_get_height (RSC_OBJ_SE_VU));
}



void	SplEdVumetres::set_height (int height)
{
	int		x;
	int		y;
	int		height_for_vu;

	height = MAX (height, 150);	// On fixe quand meme une valeur minimum

	RSC_set_height (RSC_OBJ_SE_VU, height);

	RSC_get_relative_object_position (RSC_OBJ_SE_VU_LEFT, x, y);
	height_for_vu =   height - 4
	                - RSC_get_height (RSC_OBJ_SE_VU_LEFT_VAL) - 4 - y;

	/* Change la taille des vu-metres */
	RSC_set_height (RSC_OBJ_SE_VU_LEFT_DISP, height_for_vu);
	RSC_set_height (RSC_OBJ_SE_VU_RIGHT_DISP, height_for_vu);

	/* Colle l'affichage numerique vers en bas des vu-metres */
	RSC_get_relative_object_position (RSC_OBJ_SE_VU_LEFT_DISP, x, y);
	y += height_for_vu + 4;
	RSC_set_relative_object_position (RSC_OBJ_SE_VU_LEFT_VAL, x, y);

	RSC_get_relative_object_position (RSC_OBJ_SE_VU_RIGHT_DISP, x, y);
	y += height_for_vu + 4;
	RSC_set_relative_object_position (RSC_OBJ_SE_VU_RIGHT_VAL, x, y);
}



void	SplEdVumetres::get_coordinates (int &pix_x, int &pix_y)
{
	pix_x = RSC_absolute_object_pixxpos [RSC_OBJ_SE_VU];
	pix_y = RSC_absolute_object_pixypos [RSC_OBJ_SE_VU];
}



void	SplEdVumetres::move_to (int pix_x, int pix_y)
{
	RSC_set_absolute_object_position (RSC_OBJ_SE_VU, pix_x, pix_y);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
