/*****************************************************************************

        StereoGain.cpp
        Copyright (c) 2012 Laurent de Soras

*Tab=3***********************************************************************/



#if defined (_MSC_VER)
	#pragma warning (1 : 4130 4223 4705 4706)
	#pragma warning (4 : 4355 4786 4800)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"StereoGain.h"

#include	<cassert>



/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



void	StereoGain::push_new_mix_param (int vol, int pan)
{
	int				vol_l;
	vol_l  = (ULWORD (vol & 0xFFFFL) * ULWORD (0x10000L - pan)) >> 16;
	vol_l += (vol / 65536) * (0x10000L - pan);

	int				vol_r;
	vol_r  = (ULWORD (vol & 0xFFFFL) * ULWORD (           pan)) >> 16;
	vol_r += (vol / 65536) *             pan;

	old_vol [0] = new_vol [0];
	old_vol [1] = new_vol [1];
	new_vol [0] = vol_l;
	new_vol [1] = vol_r;
}



void	StereoGain::copy_without_state (const StereoGain &other)
{
	assert (&other != 0);

	if (&other != this)
	{
		for (int chn = 0; chn < 2; ++chn)
		{
			old_vol [chn] = other.old_vol [chn];
			new_vol [chn] = other.new_vol [chn];

			const float			vol = other._gain [chn].get_vol_target ();
			_gain [chn].set (vol);
		}
	}
}



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
