/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"Container.h"
#include	"log.h"
#include	"patt.h"
#include	"UndoCell.h"
#include	"UndoCellPatChgHeight.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoCellPatChgHeight::UndoCellPatChgHeight (int pattern, int nbr_lines)
{
	_pattern = pattern;
	_nbr_lines = nbr_lines;
}



/* Ne devrait pas etre utilise tel quel */
UndoCellPatChgHeight::UndoCellPatChgHeight (void)
{
	_pattern = 0;
	_nbr_lines = 0;
}



UndoCellPatChgHeight::UndoCellPatChgHeight (const UndoCellPatChgHeight &other)
{
	_pattern = other._pattern;
	_nbr_lines = other._nbr_lines;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

UndoCellPatChgHeight::~UndoCellPatChgHeight (void)
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoCellPatChgHeight::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoCellPatChgHeight::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoCellPatChgHeight::self_display (void) const
{

	/*** A faire ***/

}



Container	*UndoCellPatChgHeight::create (void) const
{
	return (new UndoCellPatChgHeight ());
}



Container	*UndoCellPatChgHeight::clone (void) const
{
	return (new UndoCellPatChgHeight (*this));
}



void	UndoCellPatChgHeight::apply_undo (void)
{
	int		old_nbr_lines;

	old_nbr_lines = PAT_get_pattern_height (_pattern);
	if (PAT_set_pattern_height (_pattern, _nbr_lines))
	{
		LOG_printf ("UndoCellPatChgHeight::apply_undo: Error: Couldn't change the number of lines of pattern # %d.\n",
		            _pattern);
		return;
	}
	_nbr_lines = old_nbr_lines;
}



void	UndoCellPatChgHeight::apply_redo (void)
{
	apply_undo ();
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
