/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (BASE_CURRENT_INLINE)
	#error Inclusion recursive du code inline BASE.
#endif
#define	BASE_CURRENT_INLINE

#if ! defined (BASE_INLINE_INCLUDED)
#define	BASE_INLINE_INCLUDED



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<math.h>

#include	"base.h"
#include	"base_ct.h"



/*\\\ FONCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: BASE_is_null                                                   */
/*      Description: Teste si un nombre reel est quasi-nul (valeur absolue  */
/*                   inferieure a EPSILON).                                 */
/*      Parametres en entree:                                               */
/*        - val: valeur a tester.                                           */
/*      Retour: TRUE si la valeur est jugee comme quasi-nulle.              */
/*==========================================================================*/

inline bool	BASE_is_null (double val)
{
	if (val < EPSILON)
	{
		if (val > -EPSILON)
		{
			return (true);
		}
	}

	return (false);
}



/*==========================================================================*/
/*      Nom: BASE_is_infinite                                               */
/*      Description: Teste si un nombre reel est quasi-inifni (valeur       */
/*                   absolue superieure ou egale a INFINITY).               */
/*      Parametres en entree:                                               */
/*        - val: valeur a tester.                                           */
/*      Retour: TRUE si la valeur est jugee comme quasi-inifnie.            */
/*==========================================================================*/

inline bool	BASE_is_infinite (double val)
{
	if (val <= INFINITY)
	{
		if (val >= -INFINITY)
		{
			return (false);
		}
	}

	return (true);
}



/*==========================================================================*/
/*      Nom: BASE_safe_double_inversion                                     */
/*      Description: Inverse proprement un nombre a virgule flottante en    */
/*                   tenant compte des infinis possibles sans generer de    */
/*                   NaN.                                                   */
/*      Parametres en entree:                                               */
/*        - val: valeur a inverser.                                         */
/*      Retour: valeur inverse.                                             */
/*==========================================================================*/

inline double	BASE_safe_double_inversion (double val)
{
	if (BASE_is_null (val))
	{
		return (INFINITY);
	}
	else if (BASE_is_infinite (val))
	{
		return (0.0);
	}

	return (1.0 / val);
}



/*==========================================================================*/
/*      Nom: BASE_lin_to_db                                                 */
/*      Description: Passe une valeur lineaire en decibels.                 */
/*      Parametres en entree:                                               */
/*        - val: valeur lineaire.                                           */
/*      Retour: valeur en dB                                                */
/*==========================================================================*/

inline double	BASE_lin_to_db (double val)
{
	if (val > EPSILON)
	{
		return (log (val) * 20 / LN10);
	}
	
	return (-INFINITY);
}



/*==========================================================================*/
/*      Nom: BASE_db_to_lin                                                 */
/*      Description: Passe une valeur en dB en valeur lineaire              */
/*      Parametres en entree:                                               */
/*        - val: valeur en dB.                                              */
/*      Retour: valeur lineaire                                             */
/*==========================================================================*/

inline double	BASE_db_to_lin (double val)
{
	if (val > -INFINITY)
	{
		return (exp (val * LN10 * 0.05));
	}
	
	return (0);
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/

#endif

#undef BASE_CURRENT_INLINE

