/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (FILT_CURRENT_HEADER)
	#error Inclusion recursive du header FILT.
#endif
#define	FILT_CURRENT_HEADER

#if ! defined (FILT_HEADER_INCLUDED)
#define	FILT_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Types de biquads */
enum
{
	FILT_BIQUAD_LOWP = 0,
	FILT_BIQUAD_HIGHP,
	FILT_BIQUAD_BANDP,
	FILT_BIQUAD_NOTCH,

	FILT_NBR_BIQUAD_TYPES
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

void	FILT_init_filter (double *l_num_ptr, double *l_den_ptr, int &nbr_coef);
signed int	FILT_add_biquad (double *l_num_ptr, double *l_den_ptr, int &nbr_coef, double fech, double fref, double f0, double q, int type, bool mix_flag = false);
signed int	FILT_laplace_to_z (const double *l_num_ptr, const double *l_den_ptr, int nbr_coef, double fech, double f0, double *z_num_ptr, double *z_den_ptr);
signed int	FILT_z_to_diff_eq (const double *z_num_ptr, const double *z_den_ptr, int nbr_coef, double *x_coef_ptr, double *y_coef_ptr);
void	FILT_do_iir_filtering (const float *src_ptr, float *dest_ptr, int s_stereo, int d_stereo,
		                       const double *x_coef_ptr, const double *y_coef_ptr,
		                       int nbr_coef, float *x_buffer_ptr, double *y_buffer_ptr,
		                       int &buffer_pos, int buffer_len, long length);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern const char	*const FILT_biquad_name_0 [FILT_NBR_BIQUAD_TYPES];



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FILT_CURRENT_HEADER
