/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (FNAM_CURRENT_HEADER)
	#error Inclusion recursive du header FNAM.
#endif
#define	FNAM_CURRENT_HEADER

#if ! defined (FNAM_HEADER_INCLUDED)
#define	FNAM_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"String.h"



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	FNAM_FILENAME_MAXLEN		255		/* Taille maximum d'un nom de fichier */
#define	FNAM_PATHNAME_MAXLEN		255		/* Taille maximum d'un nom de chemin */



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

String	FNAM_get_drive (String path);
String	FNAM_get_path (String path);
String	FNAM_get_full_path (String path);
String	FNAM_get_full_filename (String path);
String	FNAM_parse_path_ext (String path);
bool	FNAM_test_filename (const char *filename_0, const char *mask_0);
String	FNAM_get_abs_path_from_rel (String main_path, String rel_path);
String	FNAM_get_rel_path_from_abs (String main_path, String abs_path);
void	FNAM_simplify_path (String &path);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FNAM_CURRENT_HEADER
