/*****************************************************************************

GRAOUMF TRACKER 2

Copyright (c) 1996 - 2002 Laurent de Soras

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author : laurent@ohmforce.com
More information about this license : http://www.gnu.org/licenses/gpl.html

*****************************************************************************/



#if defined (SPLS_CURRENT_HEADER)
	#error Inclusion recursive du header SPLS.
#endif
#define	SPLS_CURRENT_HEADER

#if ! defined (SPLS_HEADER_INCLUDED)
#define	SPLS_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"Popup.h"
#include	"String.h"



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Formats internes des samples */
enum
{
	SPLS_FORMAT_RAW = 0,
	SPLS_FORMAT_AVR,
	SPLS_FORMAT_WAV,
	SPLS_FORMAT_AU
};

/* Type de compression d'un sample */
enum
{
	SPLS_PACK_TYPE_UNSUP = -1,	/* Format non supporte */
	SPLS_PACK_TYPE_PCM = 0,		/* Sample normal, en PCM */
	SPLS_PACK_TYPE_DISK			/* Sample sur disque (sert pour le champ header.codagev des chunks samples dans les songs) */
};

/* Tailles min/max des buffers, en samples */
#define	SPLS_RBUF_MINLEN		16		/* Taille minimum du buffer de repetition */
#define	SPLS_RBUF_MAXLEN		4096	/* Taille maximum du buffer de repetition */
#define	SPLS_D2DBUF_MINLEN	4096	/* Taille minimum d'un buffer de D2D */



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	int		nbits;
	int		tracks;
	long		freq;
	long		length;
	long		repeat;
	long		replen;
	long		data_offset;
	signed int	finetune;
	int		midi_note;
	int		volume;
	signed int	balance;
	int		loop_type;
	signed int	pack_type;
	bool		signed_flag;
	bool		acm_flag;			// Indique si l'ACM est utilise. Ne peut servir que lors du chargement en une seule traite.
	int		acm_type;			// Audio compression manager. Depend du systeme.
	int		byte_order;
	int		special;

	/* Utilise uniquement lors de la sauvegarde des donnees */
	long		position;	/* Position du bloc a sauver */
	long		block_len;	/* Longueur du bloc a sauver */

	/* Utilise uniquement par la routine de sauvegarde d'un morceau de sample brut */
	long		file_position;	/* Indique ou prendre le bloc courant dans le fichier */
} SPLS_PRIMARY_INFO;

/* Structure contenant tous les pointeurs de fonctions utiles au chargement
   et a la sauvegarde d'un format de sample. */
typedef struct
{
	/* Nom, extension */
	const char	*name_0;
	const char	*ext_0;

	/* Sauvegarde */
	signed int	(*save_ptr) (FILE *file_ptr, int sample);
	signed int	(*save_header_ptr) (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr);
	signed int	(*save_data_ptr) (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr, void *mem_data_ptr, FILE *file_data_ptr);
	signed int	(*save_tail_ptr) (FILE *file_ptr, const SPLS_PRIMARY_INFO *sample_info_ptr);

	/* Chargement */
	signed int	(*get_primary_info_ptr) (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr);
	signed int	(*load_ptr) (FILE *file_ptr, int sample, SPLS_PRIMARY_INFO *sample_info_ptr);

	bool		import_flag;
	bool		export_flag;
} SPLS_FORMAT_ROUTINES;



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	SPLS_init (void);
void	SPLS_restore (void);

signed int	SPLS_select_sample_filename (String &total_name, const char *title_0, bool save_flag);

signed int	SPLS_save_sample (void);
signed int	SPLS_save_sample_direct (int sample, const char *filename_0);
signed int	SPLS_save_sample_header (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr);
signed int	SPLS_save_sample_data (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr, void *mem_data_ptr, FILE *file_data_ptr);
signed int	SPLS_save_sample_tail (FILE *file_ptr, const SPLS_PRIMARY_INFO *sample_info_ptr);

signed int	SPLS_save_raw_sample_block (FILE *file_ptr, const SPLS_PRIMARY_INFO *sample_info_ptr, void *mem_data_ptr, FILE *file_data_ptr);

signed int	SPLS_get_file_format (FILE *file_ptr);
signed int	SPLS_load_sample (void);
signed int	SPLS_load_sample_direct (int sample, const char *filename_0);

void	SPLS_init_primary_info (SPLS_PRIMARY_INFO *sample_info_ptr, int sample);
signed int	SPLS_get_primary_info (FILE *file_ptr, int format, SPLS_PRIMARY_INFO	*sample_info_ptr);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern int	SPLS_export_format;
extern bool	SPLS_signed_flag;

extern SPLS_FORMAT_ROUTINES	SPLS_format_routines [];
extern int	SPLS_nbr_formats;
extern Popup	*SPLS_import_format_popup_menu_ptr;
extern Popup	*SPLS_export_format_popup_menu_ptr;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SPLS_CURRENT_HEADER
