/*****************************************************************************

        D2dBuffer.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if ! defined (D2dBuffer_HEADER_INCLUDED)
#define	D2dBuffer_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma once
	#pragma warning (4 : 4250) // "Inherits via dominance."
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"

#include	<cstdio>



class Voice;

class D2dBuffer
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

						D2dBuffer ();
	virtual			~D2dBuffer ();

	void				allocate (Voice &voice);
	void				deallocate ();

	FILE *			file_ptr;			/* Pointeur fichier qui identifie le sample qui est joue */
	void *			buffer_ptr [2];	/* Adresse des buffers. Si buffer_ptr [0] est NULL, il n'y a pas de cache reserve. */
	LWORD				buf_length [2];	/* Longueur des buffers (en samples) */
	LWORD				total_length;		/* Longueur des 2 buffers en octets */
	SLWORD			buf_pos [2];		/* Position des buffers dans le sample, en samples. Peut etre legerement negative. */
	WORD				buf_flag [2];		/* Validite des donnees des buffers */



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

						D2dBuffer (const D2dBuffer &other);
	D2dBuffer &		operator = (const D2dBuffer &other);
	bool				operator == (const D2dBuffer &other);
	bool				operator != (const D2dBuffer &other);

};	// class D2dBuffer



//#include	"D2dBuffer.hpp"



#endif	// D2dBuffer_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
