/*****************************************************************************

        EnvSet.cpp
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if defined (_MSC_VER)
	#pragma warning (1 : 4130 4223 4705 4706)
	#pragma warning (4 : 4355 4786 4800)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"env.h"
#include	"EnvSet.h"
#include	"inst.h"
#include	"Pattern.h"

#include	<cassert>



/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



EnvSet::EnvSet ()
/*:	_com_env ()*/
{
	// Nothing
}



/*==========================================================================*/
/*      Nom: init_all_env                                                   */
/*      Description: Initialisation de toutes les enveloppes d'une piste.   */
/*      Parametres en entree:                                               */
/*        - instr: numero de l'instrument qui est joue. -1 enleve toutes    */
/*                 les enveloppes.                                          */
/*      Parametres en entree/sortie:                                        */
/*        - track_info_ptr: pointeur sur les infos de la piste.             */
/*==========================================================================*/

void	EnvSet::init_all_env (int instr, int track_type)
{
	assert (instr >= -1);
	assert (instr <= INST_NBRINSTR_MAXI);

	for (int env_type = 0; env_type < Envelope_NBR_TYPES; ++env_type)
	{
		if (instr < 0 || ! is_handled_envelope (track_type, env_type))
		{
			_com_env [env_type].nbr = 0;
		}

		else
		{
			const int		env_nbr = INST_get_instr_env (instr, env_type);
			_com_env [env_type].nbr = env_nbr;
			if (env_nbr > 0)
			{
				ENV_start (env_type, env_nbr, _com_env [env_type].proc);
			}
		}
	}
}



bool	EnvSet::is_handled_envelope (int track_type, int env_type)
{
	assert (track_type >= 0);
	assert (env_type >= 0);
	assert (env_type < Envelope_NBR_TYPES);

	static const long	mask = 0
		| (1L << (Pattern_TYPE_SPL * Envelope_NBR_TYPES + Envelope_TYPE_VOL   ))
		| (1L << (Pattern_TYPE_SPL * Envelope_NBR_TYPES + Envelope_TYPE_TON   ))
		| (1L << (Pattern_TYPE_SPL * Envelope_NBR_TYPES + Envelope_TYPE_PAN   ))
		| (1L << (Pattern_TYPE_SPL * Envelope_NBR_TYPES + Envelope_TYPE_CUTOFF))
		| (1L << (Pattern_TYPE_SPL * Envelope_NBR_TYPES + Envelope_TYPE_RESO  ))
		| (1L << (Pattern_TYPE_AIN * Envelope_NBR_TYPES + Envelope_TYPE_VOL   ))
		| (1L << (Pattern_TYPE_AIN * Envelope_NBR_TYPES + Envelope_TYPE_PAN   ))
		| (1L << (Pattern_TYPE_FX  * Envelope_NBR_TYPES + Envelope_TYPE_VOL   ))
		| (1L << (Pattern_TYPE_FX  * Envelope_NBR_TYPES + Envelope_TYPE_TON   ))
		| (1L << (Pattern_TYPE_FX  * Envelope_NBR_TYPES + Envelope_TYPE_PAN   ))
	;
	const int		bit_index_base = track_type * Envelope_NBR_TYPES;
	const int		bit_index = bit_index_base + env_type;
	const long		bit = 1L << bit_index;

	return ((mask & bit) != 0);
}



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
