/*****************************************************************************

        GainSmooth.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if ! defined (GainSmooth_HEADER_INCLUDED)
#define	GainSmooth_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma once
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



class GainSmooth
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

						GainSmooth ();
	virtual			~GainSmooth () {}

	void				clear_buffers ();
	void				set_initial_flag (bool initial_flag);

	void				set (float vol);
	void				force (float vol);
	bool				is_ramping () const;
	float				get_vol_cur () const;
	float				get_vol_target () const;

	void				mix (float dest_ptr [], const float src_ptr [], long nbr_spl, int stride_dst, int stride_src);
	void				replace (float dest_ptr [], const float src_ptr [], long nbr_spl, int stride_dst, int stride_src);
	void				mix_or_replace (float dest_ptr [], const float src_ptr [], long nbr_spl, int stride_dst, int stride_src, bool repl_flag);
	void				skip (long nbr_spl);
	void				scale (float scale);
	void				add (const GainSmooth &other);



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	enum {			FADE_LEN = 192	};		// Number of samples. 4 ms at 48 kHz

	template <class T>
	void				process (float dest_ptr [], const float src_ptr [], long nbr_spl, int stride_dst, int stride_src);

	static inline float
						curve (float x);

	float				_vol_old;				// Previous value (beginning of the ramp)
	float				_vol_cur;				// Current value
	float				_vol_target;			// Target value when ramping
	long				_ramp_pos;				// [0 ; FADE_LEN[. Negative = not ramping.
	bool				_initial_flag;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	bool				operator == (const GainSmooth &other) const;
	bool				operator != (const GainSmooth &other) const;

};	// class GainSmooth



//#include	"GainSmooth.hpp"



#endif	// GainSmooth_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
