/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"log.h"
#include	"PatEdMenuPref.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

enum
{
	PatEdMenuPref_SUBMENU_MAIN = 0,
	PatEdMenuPref_SUBMENU_PLAYER,

	PatEdMenuPref_NBR_SUBMENUS
};



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

PatEdMenuPref::PatEdMenuPref (void)
{
	set_submenu (PatEdMenuPref_SUBMENU_MAIN);
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuPref::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuPref::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuPref::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuPref::redraw (void)
{
	switch (_submenu)
	{
	case	PatEdMenuPref_SUBMENU_MAIN:
		_main.redraw ();
		break;

	case	PatEdMenuPref_SUBMENU_PLAYER:
		_player.redraw ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuPref::refresh (void)
{
	switch (_submenu)
	{
	case	PatEdMenuPref_SUBMENU_MAIN:
		_main.refresh ();
		break;

	case	PatEdMenuPref_SUBMENU_PLAYER:
		_player.refresh ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuPref::refresh_dynamic (bool force_flag)
{
	switch (_submenu)
	{
	case	PatEdMenuPref_SUBMENU_MAIN:
		_main.refresh_dynamic (force_flag);
		break;

	case	PatEdMenuPref_SUBMENU_PLAYER:
		_player.refresh_dynamic (force_flag);
		break;
	}
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuPref::manage (int sel_object, int sel_elder)
{
	switch (sel_object)
	{
	case	RSC_OBJ_MP_SUBM_PREF_PICN_MAIN:
		set_submenu (PatEdMenuPref_SUBMENU_MAIN);
		redraw ();
		break;

	case	RSC_OBJ_MP_SUBM_PREF_PICN_PLAY:
		set_submenu (PatEdMenuPref_SUBMENU_PLAYER);
		redraw ();
		break;

	default:
		switch (_submenu)
		{
		case	PatEdMenuPref_SUBMENU_MAIN:
			_main.manage (sel_object, sel_elder);
			break;

		case	PatEdMenuPref_SUBMENU_PLAYER:
			_player.manage (sel_object, sel_elder);
			break;
		}
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuPref::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_PREF, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SMICN_PREF, RSC_ATTR_SELECTED, activated_flag);
}



int	PatEdMenuPref::get_submenu (void) const
{
	return (_submenu);
}



void	PatEdMenuPref::set_submenu (int submenu)
{
	int		menu_cnt;
	bool		activate_flag;

	_submenu = submenu;

	/* Activation des menus */
	for (menu_cnt = 0; menu_cnt < PatEdMenuPref_NBR_SUBMENUS; menu_cnt ++)
	{
		activate_flag = (menu_cnt == _submenu);

		switch (menu_cnt)
		{
		case	PatEdMenuPref_SUBMENU_MAIN:
			_main.activate (activate_flag);
			break;

		case	PatEdMenuPref_SUBMENU_PLAYER:
			_player.activate (activate_flag);
			break;
		}
	}
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
