/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (PatEdTracks_CURRENT_HEADER)
	#error Inclusion recursive du header PatEdTracks.
#endif
#define	PatEdTracks_CURRENT_HEADER

#if ! defined (PatEdTracks_HEADER_INCLUDED)
#define	PatEdTracks_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"InterfaceComponent.h"
#include	"PatSelection.h"
#include	"Popup.h"
#include	"sliders.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class PatEdTracks
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
PatEdTracks (void);
~PatEdTracks (void);
signed int	check_ok (void) const;
void		self_display (void) const;

void		redraw (void);
void		refresh (void);
void		refresh_dynamic (bool force_flag);
void		manage (int sel_object, int sel_elder);

int		get_width (void);
int		get_height (void);
void		set_width (int width);
void		set_height (int height);
void		get_coordinates (int &pix_x, int &pix_y);
void		move_to (int pix_x, int pix_y);

void		check_cursor (void);
void		cursor_left (void);
void		cursor_right (void);
void		prev_line (void);
void		next_line (void);
void		prev_column (void);
void		next_column (void);
void		set_rel_column (int col);
void		set_abs_column (int col);

PatSelection	get_selection (bool &sel_flag) const;
void		set_selection_top_left_intr (int col, int line);
void		set_selection_bottom_right_intr (int col, int line);
void		set_selection_intr (int col, int line, int nbr_col, int nbr_lines);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
PatSelection	*_selection_ptr;	// Selection dans le pattern. NULL si pas de selection



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void		calc_max_disp_col (void);
int		get_col_width (void);
void		display_current_pattern (bool force_flag = true);
signed int	update_disp_line (int pattern, int curs_line);
void		display_pattern (int pattern, signed int disp_line, int curs_line, int curs_col, int curs_pos);
void		select_track_command (int pattern, int track_type, int line, int track);
void		select_fx_command (int pattern, int line, int track);
void		add_special_fx_command (Popup &menu, long param_type, int cmd, const char *cmd_name_0, const char *unit_0);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_width;						// Dimensions de l'espace reserve aux pistes
int		_height;
int		_max_disp_col;				// Nombre de colonnes affichees a l'ecran
int		_nbr_disp_lines;			// Nombre de lignes affichees a l'ecran
int		_current_pattern_line;	// Numero de la premiere ligne de pattern affichee. Peut etre en dehors du pattern

struct PatEdTracks_RscObj
{
	int		info;
	int		sep;
}			*_rsc_object_ptr;			// Tableau des numeros d'objets de chaque colonne de piste
int		_nbr_rsc_col;				// Nombre de colonnes de resource stoquees dans le tableau

SLID_INFO	_track_slider;			// Slider de defilement des pistes



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PatEdTracks_CURRENT_HEADER
