/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (ReconstructionFilter_CURRENT_HEADER)
	#error Inclusion recursive du header ReconstructionFilter.
#endif
#define	ReconstructionFilter_CURRENT_HEADER

#if ! defined (ReconstructionFilter_HEADER_INCLUDED)
#define	ReconstructionFilter_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"splhandl.h"

#include <array>
#include <vector>
#include <map>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class ReconstructionFilter
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	// Maximum number of channels
	static constexpr int _max_nbr_chn = 2;



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
ReconstructionFilter (int width);
~ReconstructionFilter (void);

void		resample_and_mix (const SWORD *s_buffer_ptr, float *d_buffer_ptr,
			                  LWORD length, int s_stereo, int d_stereo,
			                  SLWORD volume, ULWORD pos_frac, double rate);
void		clear_buffer (void);
void		copy_state (const ReconstructionFilter &other);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	// Maximum number of output samples generated at once.
	static constexpr int _max_blk_len = 64;

	// Number of phases for the filter
	static constexpr int _nbr_phases  = 256;



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	void           build_filter ();

	static inline float
	               sinc (float x);
	static inline float
	               window (float x);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

/* Largeur du sinus cardinal utilise pour le filtre (en samples, de part et
   d'autre de 0). Vaut normalement 64. Plus cette valeur est grande, plus le
	filtre est de bonne qualite mais plus le retard est important (il vaut
	d'ailleur _width / 2). Must be even. */
int		_width;

/* Taille du buffer stereo en samples. Doit etre une puissance de 2. */
int		_buf_len;

/* Pointeur sur le buffer stereo qui accompagne le reechantillonnage tout au
   long des frames. Ce buffer est de la taille de _width + 1. */
std::array <std::vector <float>, _max_nbr_chn>  _buffer_arr;

/* Position courante dans le buffer */
int		_buffer_pos;

class Filter
{
public:
	typedef std::array <float, 2> InterpData;
	std::vector <InterpData> _snc; // base/dif, _width * _nbr_phases + 1
	std::vector <InterpData> _win;
};

Filter * _filt_ptr = nullptr;

static std::map <int, Filter> _filter_map; // [_width] = filter



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
ReconstructionFilter (void);
ReconstructionFilter (const ReconstructionFilter &other);
void		operator = (const ReconstructionFilter &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef ReconstructionFilter_CURRENT_HEADER
