/*****************************************************************************

        ResamplerFIR.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if ! defined (ResamplerFIR_HEADER_INCLUDED)
#define	ResamplerFIR_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma once
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"

#include	<vector>



class ResamplerFIR
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	explicit			ResamplerFIR (int fir_len);
	virtual			~ResamplerFIR () {}

	void				resample_and_mix (const SWORD *s_buffer_ptr, float *d_buffer_ptr, long length, int s_stereo, int d_stereo, int volume, ULWORD pos_frac, double inv_resample_factor);
	void				clear_buffer (void);



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	typedef	std::vector <float>	Buffer;

	Buffer			_buf [2];	// Circular buffer storing input data as separate channels. Length = power of 2.
	int				_buf_mask;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

						ResamplerFIR ();
						ResamplerFIR (const ResamplerFIR &other);
	ResamplerFIR &	operator = (const ResamplerFIR &other);
	bool				operator == (const ResamplerFIR &other) const;
	bool				operator != (const ResamplerFIR &other) const;

};	// class ResamplerFIR



//#include	"ResamplerFIR.hpp"



#endif	// ResamplerFIR_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
