/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"mpannel.h"
#include	"SplEdCurrentSample.h"
#include	"resource.h"
#include	"rsc01.h"
#include	"samp.h"
#include	"Sample.h"
#include	"EditString.h"
#include	"edstring.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	SplEdCurrentSample::redraw (void)
{
	RSC_display_object (RSC_OBJ_SE_CURSPL);
	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	SplEdCurrentSample::refresh (void)
{
	char	nbr3_0 [3+1];
	char	text_0 [Sample_NAME_LEN+1];
	long		freq;
	int		nbr_tracks;
	int		nbr_bytes;

	freq = SAMP_get_sample_freq (GTK_sample_nbr);
	nbr_tracks = SAMP_get_sample_stereo (GTK_sample_nbr);
	nbr_bytes = SAMP_get_sample_resolution (GTK_sample_nbr) >> 3;

	/* Numero du sample */
	sprintf (nbr3_0, INTR_base_song_3, GTK_sample_nbr);
	RSC_set_string (RSC_OBJ_SE_CURSPL_SPL_VAL, nbr3_0);
	RSC_display_object (RSC_OBJ_SE_CURSPL_SPL_VAL);
	
	/* Length */
	INTR_splpos_2_string (text_0, SAMP_get_sample_length (GTK_sample_nbr),
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_CURSPL_LEN_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_CURSPL_LEN_VAL);

	/* Name */
	SAMP_get_sample_name (GTK_sample_nbr, text_0);
	RSC_set_string (RSC_OBJ_SE_CURSPL_NAME_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_CURSPL_NAME_VAL);

	refresh_dynamic (TRUE);
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	SplEdCurrentSample::manage (int sel_object, int /*sel_elder*/)
{
	char	text_0 [Sample_NAME_LEN+1]; 

	switch (sel_object)
	{

	/* Numero du sample */
	case	RSC_OBJ_SE_CURSPL_SPL:
		if (RSC_mouse_key == 2)
		{
			MPAN_set_sample_number (INTR_CHGTYPE_POP, 0, RSC_OBJ_SE_CURSPL_SPL_VAL);
		}
		else
		{
			MPAN_set_sample_number (INTR_CHGTYPE_KBD, 0, RSC_OBJ_SE_CURSPL_SPL_VAL);
		}
		break;

	/* Sample + */
	case	RSC_OBJ_SE_CURSPL_UP:
		MPAN_set_sample_number (INTR_CHGTYPE_REL,
										INTR_inc_speed [0] [RSC_mouse_key],
										RSC_OBJ_SE_CURSPL_SPL_VAL);
		break;

	/* Sample - */
	case	RSC_OBJ_SE_CURSPL_DOWN:
		MPAN_set_sample_number (INTR_CHGTYPE_REL,
										-INTR_inc_speed [0] [RSC_mouse_key],
										RSC_OBJ_SE_CURSPL_SPL_VAL);
		break;

	/* Length */
	case	RSC_OBJ_SE_CURSPL_LEN:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Name */
	case	RSC_OBJ_SE_CURSPL_NAME:
		SAMP_get_sample_name (GTK_sample_nbr, text_0);
		if (EDIT_edit_string (text_0, RSC_OBJ_SE_CURSPL_NAME_VAL,
									 Sample_NAME_LEN, EditString_TYPE_ALPHA) == 0)
		{
			SAMP_set_sample_name (GTK_sample_nbr, text_0);
		}
		refresh ();
		break;
	}
}



int	SplEdCurrentSample::get_width (void)
{
	return (RSC_get_width (RSC_OBJ_SE_CURSPL));
}



int	SplEdCurrentSample::get_height (void)
{
	return (RSC_get_height (RSC_OBJ_SE_CURSPL));
}



void	SplEdCurrentSample::get_coordinates (int &pix_x, int &pix_y)
{
	pix_x = RSC_absolute_object_pixxpos [RSC_OBJ_SE_CURSPL];
	pix_y = RSC_absolute_object_pixypos [RSC_OBJ_SE_CURSPL];
}



void	SplEdCurrentSample::move_to (int pix_x, int pix_y)
{
	RSC_set_absolute_object_position (RSC_OBJ_SE_CURSPL, pix_x, pix_y);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
