/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"Container.h"
#include	"List.h"
#include	"log.h"
#include	"UndoCell.h"
#include	"UndoCellList.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoCellList::UndoCellList (void)
{
}



UndoCellList::UndoCellList (const UndoCellList &other)
{
	_cell_list = other._cell_list;
}



UndoCellList::UndoCellList (List &undo_list)
{
	_cell_list = undo_list;
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoCellList::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoCellList::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoCellList::self_display (void) const
{

	/*** A faire ***/

}



Container	*UndoCellList::create (void) const
{
	return (new UndoCellList ());
}



Container	*UndoCellList::clone (void) const
{
	return (new UndoCellList (*this));
}



void	UndoCellList::apply_undo (void)
{
	List		*undo_list_ptr;
	List		new_list;
	UndoCell	*cell_ptr;

	undo_list_ptr = &_cell_list;
	while (! undo_list_ptr->is_empty ())
	{
		cell_ptr = (UndoCell *) undo_list_ptr->get (0);
		cell_ptr->apply_undo ();
		new_list.add (cell_ptr);

		undo_list_ptr = &undo_list_ptr->next ();
	}

	_cell_list = new_list;
}



void	UndoCellList::apply_redo (void)
{
	List		*redo_list_ptr;
	List		new_list;
	UndoCell	*cell_ptr;

	redo_list_ptr = &_cell_list;
	while (! redo_list_ptr->is_empty ())
	{
		cell_ptr = (UndoCell *) redo_list_ptr->get (0);
		cell_ptr->apply_redo ();
		new_list.add (cell_ptr);

		redo_list_ptr = &redo_list_ptr->next ();
	}

	_cell_list = new_list;
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
