/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (FILE_CT_CURRENT_HEADER)
	#error Inclusion recursive du header FILE_CT.
#endif
#define	FILE_CT_CURRENT_HEADER

#if ! defined (FILE_CT_HEADER_INCLUDED)
#define	FILE_CT_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "archi.h"

#include <string>

#include <cstdint>



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



const BYTE FILE_attrib_dir = 0x10;

typedef struct
{
	BYTE           attrib   = 0;
	int64_t	      length   = 0;
	BYTE		      minute   = 0;
	BYTE		      hour     = 0;
	BYTE		      day      = 1;    // Starts at 1
	BYTE		      month    = 1;    // Starts at 1
	WORD		      year     = 1900;
	bool		      selected = false;
	std::string    name;

	int64_t        timestamp () const
	{
		return (((int64_t (year) * 12 + (month - 1)) * 31 + (day - 1)) * 24 + hour) * 60 + minute;
	}
	bool           is_dir () const { return ((attrib & FILE_attrib_dir) != 0); }
} FILE_DIR_ENTRY;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FILE_CT_CURRENT_HEADER
