/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (FXP_CURRENT_HEADER)
	#error Inclusion recursive du header FXP.
#endif
#define	FXP_CURRENT_HEADER

#if ! defined (FXP_HEADER_INCLUDED)
#define	FXP_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"FxPreset.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	FXP_NBRFXP_MAXI		255		/* 1-255 */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	FXP_init (void);
void	FXP_restore (void);

/*--------------------------------------------------------------------------*/
/*      Routines de base                                                    */
/*--------------------------------------------------------------------------*/

void	FXP_get_name (int preset, char name_0 [FxPreset_NAME_LEN+1]);
void	FXP_set_name (int preset, const char *name_0);
int	FXP_get_number (int preset);
void	FXP_set_number (int preset, int number);
int	FXP_get_effect_type (int preset);
void	FXP_set_effect_type (int preset, int type);
const FxPreset_EFFECT_CONF	&FXP_get_parameters (int preset);
void	FXP_set_parameters (int preset, const FxPreset_EFFECT_CONF &conf);
signed int	FXP_kill_preset (int preset);

signed int	FXP_clear_presets (void);

/*--------------------------------------------------------------------------*/
/*      Routines utilisant l'interface                                      */
/*--------------------------------------------------------------------------*/

signed int	FXP_set_preset_number_intr (int type, signed int value);




/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FXP_CURRENT_HEADER
