/*****************************************************************************

        PatternInterface.cpp
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if defined (_MSC_VER)
	#pragma warning (1 : 4130 4223 4705 4706)
	#pragma warning (4 : 4355 4786 4800)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "gtp/PatternInterface.h"

#include <cassert>



namespace gtp
{



/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



void	PatternInterface::set_name (std::string name)
{
	do_set_name (name);
}



std::string	PatternInterface::get_name () const
{
	return do_get_name ();
}



TrackType	PatternInterface::get_type () const
{
	const TrackType   type = do_get_type ();
	assert (type >= 0);
	assert (type < TrackType_NBR_ELT);

	return type;
}



int	PatternInterface::get_cell_size () const
{
	const int      sz = do_get_cell_size ();
	assert (sz > 0);

	return sz;
}



// New tracks and lines are kept uninitialized.
void	PatternInterface::set_size (int nbr_lines, int nbr_tracks)
{
	assert (nbr_lines > 0);
	assert (nbr_tracks > 0);

	do_set_size (nbr_lines, nbr_tracks);
}



void	PatternInterface::set_height (int nbr_lines)
{
	assert (nbr_lines > 0);

	do_set_height (nbr_lines);
}



void	PatternInterface::set_width (int nbr_tracks)
{
	assert (nbr_tracks > 0);

	do_set_width (nbr_tracks);
}



int	PatternInterface::get_nbr_lines () const
{
	const int      nbr_lines = do_get_nbr_lines ();
	assert (nbr_lines > 0);

	return nbr_lines;
}



int	PatternInterface::get_nbr_tracks () const
{
	const int      nbr_tracks = do_get_nbr_tracks ();
	assert (nbr_tracks > 0);

	return nbr_tracks;
}



uint8_t *	PatternInterface::use_raw (int line, int track)
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	uint8_t *      ptr = do_use_raw (line, track);
	assert (ptr != 0);

	return ptr;
}



const uint8_t*	PatternInterface::use_raw (int line, int track) const
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	const uint8_t* ptr = do_use_raw (line, track);
	assert (ptr != 0);

	return ptr;
}



void	PatternInterface::set_cell (int line, int track, const uint8_t raw_ptr [])
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());
	assert (raw_ptr != 0);

	do_set_cell (line, track, raw_ptr);
}



void	PatternInterface::clear (int line, int track)
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	do_clear (line, track);
}



uint16_t	PatternInterface::get_cmd (int line, int track) const
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	return do_get_cmd (line, track);
}



void	PatternInterface::set_cmd (int line, int track, uint16_t cmd)
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	do_set_cmd (line, track, cmd);
}



uint8_t	PatternInterface::get_vol (int line, int track) const
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	return do_get_vol (line, track);
}



void	PatternInterface::set_vol (int line, int track, uint8_t vol)
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	do_set_vol (line, track, vol);
}



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



}  // namespace gtp



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
