/*****************************************************************************

        PatternInterface.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (gtp_PatternInterface_HEADER_INCLUDED)
#define gtp_PatternInterface_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "gtp/TrackType.h"

#include <string>

#include <cstdint>



namespace gtp
{



class PatternInterface
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	virtual        ~PatternInterface () = default;

	void           set_name (std::string name);
	std::string    get_name () const;

	TrackType      get_type () const;
	int            get_cell_size () const;

	void           set_size (int nbr_lines, int nbr_tracks);
	void           set_height (int nbr_lines);
	void           set_width (int nbr_tracks);

	int            get_nbr_lines () const;
	int            get_nbr_tracks () const;

	uint8_t *      use_raw (int line, int track);
	const uint8_t* use_raw (int line, int track) const;
	void           set_cell (int line, int track, const uint8_t raw_ptr []);

	void           clear (int line, int track);
	uint16_t       get_cmd (int line, int track) const;
	void           set_cmd (int line, int track, uint16_t cmd);
	uint8_t        get_vol (int line, int track) const;
	void           set_vol (int line, int track, uint8_t vol);



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:

	virtual void   do_set_name (std::string name) = 0;
	virtual std::string
	               do_get_name () const = 0;

	virtual TrackType
	               do_get_type () const = 0;
	virtual int    do_get_cell_size () const = 0;

	virtual void   do_set_size (int nbr_lines, int nbr_tracks) = 0;
	virtual void   do_set_height (int nbr_lines) = 0;
	virtual void   do_set_width (int nbr_tracks) = 0;

	virtual int    do_get_nbr_lines () const = 0;
	virtual int    do_get_nbr_tracks () const = 0;

	virtual uint8_t *
	               do_use_raw (int line, int track) = 0;
	virtual const uint8_t *
	               do_use_raw (int line, int track) const = 0;
	virtual void   do_set_cell (int line, int track, const uint8_t raw_ptr []) = 0;

	virtual void   do_clear (int line, int track) = 0;
	virtual uint16_t
	               do_get_cmd (int line, int track) const = 0;
	virtual void   do_set_cmd (int line, int track, uint16_t cmd) = 0;
	virtual uint8_t
	               do_get_vol (int line, int track) const = 0;
	virtual void   do_set_vol (int line, int track, uint8_t vol) = 0;



}; // class PatternInterface



}  // namespace gtp



//#include "gtp/PatternInterface.hpp"



#endif   // gtp_PatternInterface_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
