/*****************************************************************************

        PatternMixinGeneric.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (gtp_PatternMixinGeneric_HEADER_INCLUDED)
#define gtp_PatternMixinGeneric_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "gtp/PatternInterface.h"

#include <vector>



namespace gtp
{



template <typename CT>
class PatternMixinGeneric
:	public PatternInterface
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	typedef CT               CellType;

	virtual        ~PatternMixinGeneric () = default;

	CT &           use_cell (int line, int track);
	const CT &     use_cell (int line, int track) const;




/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:

	typedef std::vector <CT> CellArray;

	// PatternInterface
	virtual void   do_set_name (std::string name);
	virtual std::string
	               do_get_name () const;

	virtual TrackType
	               do_get_type () const;
	virtual int    do_get_cell_size () const;

	virtual void   do_set_size (int nbr_lines, int nbr_tracks);
	virtual void   do_set_height (int nbr_lines);
	virtual void   do_set_width (int nbr_tracks);

	virtual int    do_get_nbr_lines () const;
	virtual int    do_get_nbr_tracks () const;

	virtual uint8_t *
	               do_use_raw (int line, int track);
	virtual const uint8_t *
	               do_use_raw (int line, int track) const;
	virtual void   do_set_cell (int line, int track, const uint8_t raw_ptr []);

	virtual void   do_clear (int line, int track);
	virtual uint16_t
	               do_get_cmd (int line, int track) const;
	virtual void   do_set_cmd (int line, int track, uint16_t cmd);
	virtual uint8_t
	               do_get_vol (int line, int track) const;
	virtual void   do_set_vol (int line, int track, uint8_t vol);

	CellArray      _cell_arr   = CellArray (1);
	int            _nbr_tracks = 1;
	int            _nbr_lines  = 1;
	std::string    _name;



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	bool           operator == (const PatternMixinGeneric <CT> &other) const = delete;
	bool           operator != (const PatternMixinGeneric <CT> &other) const = delete;

}; // class PatternMixinGeneric



}  // namespace gtp



#include "gtp/PatternMixinGeneric.hpp"



#endif   // gtp_PatternMixinGeneric_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
