/*****************************************************************************

        PatternMixinGeneric.hpp
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if ! defined (gtp_PatternMixinGeneric_CODEHEADER_INCLUDED)
#define gtp_PatternMixinGeneric_CODEHEADER_INCLUDED



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include <algorithm>

#include <cassert>



namespace gtp
{



/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



template <typename CT>
void	PatternMixinGeneric <CT>::do_set_name (std::string name)
{
	_name = name;
}



template <typename CT>
std::string	PatternMixinGeneric <CT>::do_get_name () const
{
	return _name;
}



template <typename CT>
CT &	PatternMixinGeneric <CT>::use_cell (int line, int track)
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	return _cell_arr [line * _nbr_tracks + track];
}



template <typename CT>
const CT &	PatternMixinGeneric <CT>::use_cell (int line, int track) const
{
	assert (line >= 0);
	assert (line < get_nbr_lines ());
	assert (track >= 0);
	assert (track < get_nbr_tracks ());

	return _cell_arr [line * _nbr_tracks + track];
}



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



template <typename CT>
TrackType	PatternMixinGeneric <CT>::do_get_type () const
{
	return CT::_type;
}



template <typename CT>
int	PatternMixinGeneric <CT>::do_get_cell_size () const
{
	return int (sizeof (CellType));
}



template <typename CT>
void	PatternMixinGeneric <CT>::do_set_size (int nbr_lines, int nbr_tracks)
{
	CellArray      cell_arr_new (nbr_lines * nbr_tracks);
	const int      copy_lines  = std::min (nbr_lines , _nbr_lines );
	const int      copy_tracks = std::min (nbr_tracks, _nbr_tracks);

	for (int y = 0; y < copy_lines; ++y)
	{
		for (int x = 0; x < copy_tracks; ++y)
		{
			cell_arr_new [y * nbr_tracks + x] = use_cell (y, x);
		}
	}

	_cell_arr.swap (cell_arr_new);
	_nbr_tracks = nbr_tracks;
	_nbr_lines  = nbr_lines;
}



template <typename CT>
void	PatternMixinGeneric <CT>::do_set_height (int nbr_lines)
{
	set_size (nbr_lines, _nbr_tracks);
}



template <typename CT>
void	PatternMixinGeneric <CT>::do_set_width (int nbr_tracks)
{
	set_size (_nbr_lines, nbr_tracks);
}



template <typename CT>
int	PatternMixinGeneric <CT>::do_get_nbr_lines () const
{
	return _nbr_lines;
}



template <typename CT>
int	PatternMixinGeneric <CT>::do_get_nbr_tracks () const
{
	return _nbr_tracks;
}



template <typename CT>
uint8_t *	PatternMixinGeneric <CT>::do_use_raw (int line, int track)
{
	return reinterpret_cast <uint8_t *> (&use_cell (line, track));
}



template <typename CT>
const uint8_t *	PatternMixinGeneric <CT>::do_use_raw (int line, int track) const
{
	return reinterpret_cast <const uint8_t *> (&use_cell (line, track));
}



template <typename CT>
void	PatternMixinGeneric <CT>::do_set_cell (int line, int track, const uint8_t raw_ptr [])
{
	use_cell (line, track) = *reinterpret_cast <const CellType *> (raw_ptr);
}



template <typename CT>
void	PatternMixinGeneric <CT>::do_clear (int line, int track)
{
	CellType &     cell = use_cell (line, track);
	cell.clear ();
}



template <typename CT>
uint16_t	PatternMixinGeneric <CT>::do_get_cmd (int line, int track) const
{
	const CellType &  cell = use_cell (line, track);

	return cell.get_cmd ();
}



template <typename CT>
void	PatternMixinGeneric <CT>::do_set_cmd (int line, int track, uint16_t cmd)
{
	CellType &     cell = use_cell (line, track);
}



template <typename CT>
uint8_t	PatternMixinGeneric <CT>::do_get_vol (int line, int track) const
{
	const CellType &  cell = use_cell (line, track);

	return cell.get_vol ();
}



template <typename CT>
void	PatternMixinGeneric <CT>::do_set_vol (int line, int track, uint8_t vol)
{
	CellType &     cell = use_cell (line, track);
}



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



}  // namespace gtp



#endif   // gtp_PatternMixinGeneric_CODEHEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
