/*****************************************************************************

        RefPtr.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (gtp_RefPtr_HEADER_INCLUDED)
#define gtp_RefPtr_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "conc/AtomicInt.h"
#include "conc/CellPool.h"
#include "conc/LockFreeCell.h"



namespace gtp
{



template <class T>
class RefPtr
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	typedef T                      DataType;
	typedef conc::LockFreeCell <T> CellType;
	typedef conc::CellPool <T>     PoolType;


	               RefPtr ();
	               RefPtr (const RefPtr <T> &other);
	explicit       RefPtr (CellType *cell_ptr, PoolType *pool_ptr);
	               ~RefPtr ();

	RefPtr <T> &   operator = (const RefPtr <T> &other);
	void           swap (RefPtr<T> &other);

	               operator RefPtr <const T> () const;

	conc::CellPool <T> *
	               get_pool () const;

	T *            get () const;
	T *            operator -> () const;
	T &            operator * () const;
	void           destroy ();

	long           get_count () const;

	bool           is_valid () const;



/*\\\ INTERNAL \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

	// Do not use those functions (for implementation only)
	               RefPtr (CellType *other_ptr, conc::AtomicInt <long> *count_ptr, PoolType *pool_ptr);
	conc::AtomicInt <long> *
	               get_counter_ref () const;



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	bool           is_consistent (const RefPtr <T> &other) const;

	void           add_ref ();
	void           destroy_complete ();

	CellType *     _cell_ptr;     // 0 if no associated object
	PoolType *     _pool_ptr;     // 0 if no associated object
	conc::AtomicInt <long> *
	               _count_ptr;    // 0 if no associated object



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

}; // class RefPtr



}  // namespace gtp



#include "gtp/RefPtr.hpp"



#endif   // gtp_RefPtr_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
