/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2020

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (GTK_CURRENT_HEADER)
	#error Inclusion recursive du header GTK.
#endif
#define	GTK_CURRENT_HEADER

#if ! defined (GTK_HEADER_INCLUDED)
#define	GTK_HEADER_INCLUDED



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"fnames.h"
#include	"fx_p.h"
#include	"mixp.h"
#include	"patt.h"
#include	"Pattern.h"
#include	"PatternTools.h"
#include	"samp.h"
#include	"UndoList.h"

#include	<list>
#include <mutex>

class ConfigKey;



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	GTK_VERSION_NUMBER	27	/* Version du Graoumf Tracker */
#define	GTK_LAST_MOD_YEAR		2022		/* Year of the last source code modification */

/* Pour le mixer */
#define	GTK_TRACK_TYPE_AOU		Pattern_NBR_TYPES			/* Audio Out */
#define	GTK_NBR_MIX_TRACK_TYPE	(Pattern_NBR_TYPES + 1)	/* Nombre de types de piste pour le mixer */

/* Numeros de pattern */
#define	GTK_NBRPATTERNS_ZONE	PAT_NBRPATTERNS_MAXI		/* Nombre de patterns dans la zone des chunks */
#define	GTK_PATTERN_BIDON_A	GTK_NBRPATTERNS_ZONE		/* Ces deux patterns ne font pas    */
#define	GTK_PATTERN_BIDON_B	(GTK_NBRPATTERNS_ZONE + 1)	/* partie de l'espace des chunks */
#define	GTK_NBRPATTERNS_TOTAL	(GTK_NBRPATTERNS_ZONE + 2)

/* Numeros des samples */
#define	GTK_SAMPLE_TEMP	(SAMP_NBRSAMPLES_MAXI + 1)		/* Chunk temporaire des presets de mixage */
#define	GTK_NBRSAMPLES_TOTAL	(SAMP_NBRSAMPLES_MAXI + 1)

/* Numeros des presets de mixage */
#define	GTK_MIXP_TEMP		(MIXP_NBRMIXP_MAXI + 1)		/* Chunk temporaire des presets de mixage */
#define	GTK_NBRMIXP_TOTAL	(MIXP_NBRMIXP_MAXI + 1)

/* Numeros des preset d'effet */
#define	GTK_FXP_TEMP		(FXP_NBRFXP_MAXI + 1)		/* Chunk temporaire des presets d'effets */
#define	GTK_NBRFXP_TOTAL	(FXP_NBRFXP_MAXI + 1)

/* Configuration initiale */
#define	GTK_INIT_NBR_SPL_TRACKS	8
#define	GTK_INIT_NBR_FX_TRACKS	0
#define	GTK_INIT_NBR_MID_TRACKS	0



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int GTK_main (int argc, char *argv []);

/*--------------------------------------------------------------------------*/
/*      Modification des variables                                          */
/*--------------------------------------------------------------------------*/

int	GTK_get_song_position (void);
void	GTK_set_song_position (int songpos);
int	GTK_get_current_pattern_number (void);
void	GTK_set_current_pattern_number (int pattern);
int	GTK_get_line_position (void);
void	GTK_set_line_position (int linepos);
void	GTK_set_cur_instr (int instr);
void	GTK_set_cur_sample (int sample);
int	GTK_get_edit_status (void);
void	GTK_set_edit_status (int status);

/*--------------------------------------------------------------------------*/
/*      Divers                                                              */
/*--------------------------------------------------------------------------*/

bool	GTK_mod_is_modified (void);
signed int	GTK_read_module_editing_conf (const std::list <ConfigKey> &key_list);

int	GTK_note_section_to_string (const UBYTE *data_ptr, int type, char *text_ptr);
int	GTK_note_to_string (const void *note_ptr, char *text_ptr, int track_type, int display_type);

int	GTK_get_ext_track_type (int track_type, const void *note_ptr);
int	GTK_get_fx_ext_track_type (const void *note_ptr);
int	GTK_get_mid_ext_track_type (const void *note_ptr);
void	GTK_next_line (void);
void	GTK_cherche_next_line_spl (BYTE mask1, LWORD mask2, bool full_flag);

void	GTK_stop_all (void);
void	GTK_play_pattern_bidon (void);
void	GTK_play_one_line (int pattern, int line_pos);
void	GTK_play_context (int pattern, int line_pos);
void	GTK_play_pattern (bool cont_flag);
void	GTK_play_song (bool cont_flag);
void	GTK_set_correct_cursor_color (void);

signed int	GTK_clear_song (void);
signed int	GTK_clear_instruments (void);
signed int	GTK_clear_all (void);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern std::mutex	GTK_mutex;

extern bool	GTK_modified_flag;

extern PatternTools	*GTK_pattern_block_ptr;
extern UndoList		*GTK_undo_list_ptr;

extern int	GTK_nbr_tracks [GTK_NBR_MIX_TRACK_TYPE];

extern int	GTK_instr_nbr;
extern int	GTK_sample_nbr;
extern int	GTK_mix_nbr;
extern int	GTK_fx_preset_nbr;
extern bool	GTK_fx_real_time_mode_flag;
extern bool	GTK_spl_instr_interdep_flag;

extern LWORD	GTK_default_d2d_buffer_len;

extern int	GTK_octave;
extern signed int	GTK_line_step;

extern QWORD	GTK_test_time [10];

extern bool	GTK_ask_for_exit_flag;
extern bool	GTK_exit_now_flag;
extern bool	GTK_ask_for_resolution_change_flag;
extern int	GTK_new_res_width;
extern int	GTK_new_res_height;

extern char	GTK_drag_and_drop_filename_0 [FNAM_PATHNAME_MAXLEN+1];
extern bool	GTK_ask_for_loading_module_flag;
extern char	GTK_skin_pathname_0 [FNAM_PATHNAME_MAXLEN+1];
extern bool	GTK_ask_for_loading_skin_flag;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef GTK_CURRENT_HEADER
