/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (INST_CURRENT_HEADER)
	#error Inclusion recursive du header INST.
#endif
#define	INST_CURRENT_HEADER

#if ! defined (INST_HEADER_INCLUDED)
#define	INST_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include <set>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	INST_NBRINSTR_MAXI		255		/* 1-255 */
constexpr int INST_VOL_MAX =     0x100;



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	INST_init (void);
void	INST_restore (void);

/*--------------------------------------------------------------------------*/
/*      Routines de base                                                    */
/*--------------------------------------------------------------------------*/

void	INST_get_instr_name (int instr, char *name_0);
void	INST_set_instr_name (int instr, const char *name_0);
int	INST_get_instr_volume (int instr);
void	INST_set_instr_volume (int instr, int volume);
signed int	INST_get_instr_autobal (int instr);
void	INST_set_instr_autobal (int instr, signed int balance);
int	INST_get_instr_quality (int instr);
void	INST_set_instr_quality (int instr, int quality);
int	INST_get_instr_sample (int instr, int note);
void	INST_set_instr_sample (int instr, int note, int sample);
signed int	INST_get_instr_transp (int instr, int note);
void	INST_set_instr_transp (int instr, int note, signed int transp);
int	INST_get_instr_zone_start (int instr, int note);
int	INST_get_instr_zone_end (int instr, int note);
int	INST_get_instr_env (int instr, int type);
void	INST_set_instr_env (int instr, int type, int env);
bool	INST_get_filter_flag (int instr);
void	INST_set_filter_flag (int instr, bool flag);
bool	INST_get_filter_freq_vol_flag (int instr);
void	INST_set_filter_freq_vol_flag (int instr, bool flag);
bool	INST_get_filter_q_vol_flag (int instr);
void	INST_set_filter_q_vol_flag (int instr, bool flag);
double	INST_get_filter_freq (int instr, int type);
void	INST_set_filter_freq (int instr, int type, double val);
double	INST_get_filter_q (int instr, int type);
void	INST_set_filter_q (int instr, int type, double val);

// Helper functions
signed int	INST_kill_instr (int instr);
signed int	INST_clear_instruments (void);
void	INST_find_samples_for_inst (int instr, std::set <int> &result);

/*--------------------------------------------------------------------------*/
/*      Routines avec utilisation de l'interface                            */
/*--------------------------------------------------------------------------*/

signed int	INST_set_instr_volume_intr (int type, signed int value);
signed int	INST_set_instr_env_intr (int type, signed int value, int env_type);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef INST_CURRENT_HEADER
