/*****************************************************************************

        midi.h
        Author: Laurent de Soras, 2022

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (midi_HEADER_INCLUDED)
#define	midi_HEADER_INCLUDED



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include <cstdint>



namespace midi
{



static constexpr int      _nbr_chn   =  16;
static constexpr int      _chn_mask  = 0xF;
static constexpr int      _nbr_notes = 128;
static constexpr uint8_t  _note_cmid =  60; // ~262 Hz
static constexpr uint8_t  _note_a440 =  69;
static constexpr uint8_t  _def_velo  = 0x40;

static constexpr uint8_t  _max_1b    =   0x7F;
static constexpr uint16_t _max_2b    = 0x3FFF;

// Test mask for a status command
static constexpr uint8_t  _st_mask   = 0x80;

// Status commands, as masks for the 4 upper bits
static constexpr uint8_t  _st_chn_note_off   = 0x8;
static constexpr uint8_t  _st_chn_note_on    = 0x9;
static constexpr uint8_t  _st_chn_note_after = 0xA;
static constexpr uint8_t  _st_chn_ctrl       = 0xB;
static constexpr uint8_t  _st_chn_prog       = 0xC;
static constexpr uint8_t  _st_chn_press      = 0xD;
static constexpr uint8_t  _st_chn_pitch      = 0xE;
static constexpr uint8_t  _st_sys            = 0xF;

// System common status bytes
static constexpr uint8_t  _st_com_sysex     = 0xF0;
static constexpr uint8_t  _st_com_mtc_qfm   = 0xF1;
static constexpr uint8_t  _st_com_song_pos  = 0xF2;
static constexpr uint8_t  _st_com_song_sel  = 0xF3;
static constexpr uint8_t  _st_com_tune_req  = 0xF6;
static constexpr uint8_t  _st_com_sysex_end = 0xF7;

// System real-time status bytes
static constexpr uint8_t  _st_rt_mask     = 0xF8; // Test mask
static constexpr uint8_t  _st_rt_clock    = 0xF8;
static constexpr uint8_t  _st_rt_start    = 0xFA;
static constexpr uint8_t  _st_rt_cont     = 0xFB;
static constexpr uint8_t  _st_rt_stop     = 0xFC;
static constexpr uint8_t  _st_rt_act_sens = 0xFE;
static constexpr uint8_t  _st_rt_reset    = 0xFF;

// 14-bit controllers
// These are the coarse parts, the fine parts are offseted from + 0x20
static constexpr uint8_t  _ct_bank_select = 0x00;
static constexpr uint8_t  _ct_mod_wheel   = 0x01;
static constexpr uint8_t  _ct_breath_ctrl = 0x02;
static constexpr uint8_t  _ct_foot_pedal  = 0x04;
static constexpr uint8_t  _ct_porta_time  = 0x05;
static constexpr uint8_t  _ct_data_entry  = 0x06;
static constexpr uint8_t  _ct_volume      = 0x07;
static constexpr uint8_t  _ct_balance     = 0x08;
static constexpr uint8_t  _ct_pan         = 0x0A;
static constexpr uint8_t  _ct_expression  = 0x0B;
static constexpr uint8_t  _ct_fx_ctrl_1   = 0x0C;
static constexpr uint8_t  _ct_fx_ctrl_2   = 0x0D;
static constexpr uint8_t  _ct_fine_offset = 0x20; // Offset for the fine part

// Other 14-bit controllers
static constexpr uint8_t  _ct_nrpn_lsb = 0x62;
static constexpr uint8_t  _ct_nrpn_msb = 0x63;
static constexpr uint8_t  _ct_rpn_lsb  = 0x64;
static constexpr uint8_t  _ct_rpn_msb  = 0x65;

// 7-bit controllers
static constexpr uint8_t  _ct_gp_slider_1      = 0x10;
static constexpr uint8_t  _ct_gp_slider_2      = 0x11;
static constexpr uint8_t  _ct_gp_slider_3      = 0x12;
static constexpr uint8_t  _ct_gp_slider_4      = 0x13;
static constexpr uint8_t  _ct_snd_var          = 0x46;
static constexpr uint8_t  _ct_snd_timbre       = 0x47;
static constexpr uint8_t  _ct_snd_release_time = 0x48;
static constexpr uint8_t  _ct_snd_attack_time  = 0x49;
static constexpr uint8_t  _ct_snd_brightness   = 0x4A;
static constexpr uint8_t  _ct_snd_ctrl_6       = 0x4B;
static constexpr uint8_t  _ct_snd_ctrl_7       = 0x4C;
static constexpr uint8_t  _ct_snd_ctrl_8       = 0x4D;
static constexpr uint8_t  _ct_snd_ctrl_9       = 0x4E;
static constexpr uint8_t  _ct_snd_ctrl_10      = 0x4F;
static constexpr uint8_t  _ct_fx_lvl           = 0x5B;
static constexpr uint8_t  _ct_tremolo_lvl      = 0x5C;
static constexpr uint8_t  _ct_chorus_lvl       = 0x5D;
static constexpr uint8_t  _ct_celeste_lvl      = 0x5E;
static constexpr uint8_t  _ct_phaser_lvl       = 0x5F;

// 1-bit controllers
static constexpr uint8_t  _ct_hold          = 0x40;
static constexpr uint8_t  _ct_portamento    = 0x41;
static constexpr uint8_t  _ct_sustenuto     = 0x42;
static constexpr uint8_t  _ct_soft          = 0x43;
static constexpr uint8_t  _ct_legato        = 0x44;
static constexpr uint8_t  _ct_hold_2        = 0x45;
static constexpr uint8_t  _ct_gp_button_1   = 0x50;
static constexpr uint8_t  _ct_gp_button_2   = 0x51;
static constexpr uint8_t  _ct_gp_button_3   = 0x52;
static constexpr uint8_t  _ct_gp_button_4   = 0x53;
static constexpr uint8_t  _ct_loc_keyboard  = 0x7A;

// No data controllers
static constexpr uint8_t  _ct_data_but_inc  = 0x60;
static constexpr uint8_t  _ct_data_but_dec  = 0x61;
static constexpr uint8_t  _ct_all_snd_off   = 0x78;
static constexpr uint8_t  _ct_all_ctrl_off  = 0x79;
static constexpr uint8_t  _ct_all_notes_off = 0x7B;
static constexpr uint8_t  _ct_omni_on       = 0x7C;
static constexpr uint8_t  _ct_omni_off      = 0x7D;
static constexpr uint8_t  _ct_mono_op       = 0x7E;
static constexpr uint8_t  _ct_poly_op       = 0x7F;

// RPN
static constexpr uint16_t _rpn_pitch_bend_range = 0x0000;
static constexpr uint16_t _rpn_mast_tune_fine   = 0x0001;
static constexpr uint16_t _rpn_mast_tune_coarse = 0x0002;
static constexpr uint16_t _rpn_reset            = 0x3FFF;



};	// namespace midi



//#include "midi.hpp"



#endif	// midi_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
