/*****************************************************************************

        mod_mid.h
        Author: Laurent de Soras, 2022

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://www.wtfpl.net/ for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (mod_mid_HEADER_INCLUDED)
#define mod_mid_HEADER_INCLUDED



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"modstruc.h"

#include <cstdio>



/*\\\ PUBLIC FUNCTION PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

int	MODMID_save_module (FILE *file_ptr);
int	MODMID_save_song (FILE *file_ptr);

int	MODMID_load_module (FILE *file_ptr, BYTE temp_info [MODS_TEMP_INFO_LEN]);
int	MODMID_load_song (FILE *file_ptr, BYTE temp_info [MODS_TEMP_INFO_LEN]);
bool	MODMID_detect_format (FILE *file_ptr, const void *header_ptr, long header_length, BYTE temp_info [MODS_TEMP_INFO_LEN]);




//#include "mod_mid.hpp"



#endif   // mod_mid_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
