/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (MODS_CT_CURRENT_HEADER)
	#error Inclusion recursive du header MODS_CT.
#endif
#define	MODS_CT_CURRENT_HEADER

#if ! defined (MODS_CT_HEADER_INCLUDED)
#define	MODS_CT_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "archi.h"



/*\\\ CONSTANTES ET MACROS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Plutot utiliser ca a la place du sizeof () */
#define	MODS_GT2_SPL_NOTE_LEN		5
#define	MODS_GT2_AIN_NOTE_LEN		3
#define	MODS_GT2_FX_NOTE_LEN			7
#define	MODS_GT2_MID_NOTE_LEN		4

/* La note qui prend le plus de place */
#define	MODS_GT2_MAX_NOTE_LEN		MODS_GT2_FX_NOTE_LEN



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Attention longueurs impaires, ne pas sizeofer sous Pure C ! */

typedef struct
{
	UBYTE		note;
	UBYTE		instr;
	UBYTE		fxnum;
	UBYTE		fxparam;
	UBYTE		volume;
} MODS_GT2_SPL_NOTE;			/* 5 octets */

typedef struct
{
	UBYTE		fxnum;
	UBYTE		fxparam;
	UBYTE		volume;
} MODS_GT2_AIN_NOTE;			/* 3 octets */

typedef struct
{
	UBYTE		comnum1;
	UBYTE		comnum2;
	UBYTE		comparam_msb;
	UBYTE		comparam_lsb;
	UBYTE		fxnum;
	UBYTE		fxparam;
	UBYTE		volume;
} MODS_GT2_FX_NOTE;			/* 7 octets */

typedef struct
{
	union
	{
		struct					/* Commande normale */
		{
			UBYTE		command;		/* Numero de commande normale */
			UBYTE		data [3];	/* Donnees des commandes normales */
		}			normal;
		LWORD		sysex_num;	/* Numero (0xF0 + 24 bits!) dans la table des System Exclusives */
	} event;
} MODS_GT2_MID_NOTE;			/* 4 octets */



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MODS_CT_CURRENT_HEADER
