/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (MPAN_CURRENT_HEADER)
	#error Inclusion recursive du header MPAN.
#endif
#define	MPAN_CURRENT_HEADER

#if ! defined (MPAN_HEADER_INCLUDED)
#define	MPAN_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*--------------------------------------------------------------------------*/
/*      Gestions du panneau principal                                       */
/*--------------------------------------------------------------------------*/

bool	MPAN_manage_all (void);
void	MPAN_manage_main_icons (signed int sel_object, signed int sel_aine);
void	MPAN_manage_variables (int sel_object, int sel_aine);

void	MPAN_set_song_position (int type, signed int value);
signed int	MPAN_set_instrument_number (int type, signed int value, int object);
signed int	MPAN_set_sample_number (int type, signed int value, int object);
void	MPAN_set_line_step (int type, signed int value);
void	MPAN_set_song_speed (int type, signed int value);
void	MPAN_set_song_tempo (int type, double value);

/*--------------------------------------------------------------------------*/
/*      Affichages                                                          */
/*--------------------------------------------------------------------------*/

void	MPAN_display_main_pannel (void);
void	MPAN_display_status (bool disp_flag);
void	MPAN_display_cpu_time (bool disp_flag);
void	MPAN_display_clipping_level (bool disp_flag);
signed int	MPAN_display_message (const char *message_0);
void	MPAN_display_var_icons (bool disp_flag, bool force_flag);
void	MPAN_display_play_status (void);
void	MPAN_display_divers (void);
void	MPAN_refresh_display (void);
void	MPAN_refresh_dynamic_display (void);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MPAN_CURRENT_HEADER
