/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (OS_CURRENT_HEADER)
	#error Inclusion recursive du header OS.
#endif
#define	OS_CURRENT_HEADER

#if ! defined (OS_HEADER_INCLUDED)
#define	OS_HEADER_INCLUDED



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	WIN32_LEAN_AND_MEAN
#define	NOMINMAX
#include <windows.h>
#include <windowsx.h>
#if defined (MODULE_OS)
	#if ! defined (DIRECTINPUT_VERSION)
		#define	DIRECTINPUT_VERSION	0x0800
	#endif
	#include	<dinput.h>
#endif

#include "archi.h"
#include	"SoundDriver.h"
#include	"Thread.h"

#include <string>
#include <vector>

#include	<cstdio>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	OS_ALIGNEMENT_MIN			4		/* Alignement des adresses, en octets */
#define	OS_MAX_PLAY_CONFIG		64		/* Nombre maximum de configurations de replay pour un driver */

/* Configuration de replay */
#define	OS_CONFIG_REPLAY_STEREO	0x10000000
#define	OS_CONFIG_RECORD_STEREO	0x20000000
#define	OS_CONFIG_REPLAY_16BITS	0x40000000
#define	OS_CONFIG_RECORD_16BITS	0x80000000

/* Indique si on utilise la frequence du CPU pour mesurer le temps. Ne pas
	definir ce symbole si on veut utiliser un autre systeme de mesure. */
#undef	OS_USE_CPU_FREQUENCY



/*\\\ TYPES & STRUCTURES PUBLICS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES PUBLICS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*--------------------------------------------------------------------------*/
/*      Initialisations                                                     */
/*--------------------------------------------------------------------------*/

signed int	OS_first_init (void);
void	OS_first_restore (void);
signed int	OS_init_sound_system (void);
void	OS_restore_sound_system (void);

/*--------------------------------------------------------------------------*/
/*      Clavier & souris                                                    */
/*--------------------------------------------------------------------------*/

bool	OS_key_pressed (void);
LWORD	OS_get_key (void);

/*--------------------------------------------------------------------------*/
/*      Divers                                                              */
/*--------------------------------------------------------------------------*/

QWORD	OS_get_time (void);
void	OS_processor_frequency_measurement (void);
void	OS_change_app_title (const char *title_0);
signed int	OS_launch_html_file (const char *filename_0);

std::vector <std::string> OS_load_mru_mod_list ();
void OS_save_mru_mod_list (const std::vector <std::string> &mru);

/* Fonctions publiques destinees uniquement aux sous-modules de OS */
#ifdef MODULE_OS
#endif



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern Thread	OS_main_thread;

extern SoundDriver	OS_sound_driver;
extern LWORD	OS_min_replay_freq;
extern LWORD	OS_max_replay_freq;
extern int	OS_nbr_play_config;
extern LWORD	OS_play_config [OS_MAX_PLAY_CONFIG];

extern QWORD	OS_clock_ticks_per_sec;
extern bool	OS_clock_ticks_per_sec_counted_flag;

extern int	OS_cpu_time;

/* Variables publiques destinees uniquement aux sous-modules de OS */
#ifdef MODULE_OS
	extern HINSTANCE	OS_application_instance;
	extern HWND	OS_window_handle;
	extern bool	OS_active_application_flag;
	#if defined (DINP_CURRENT_MODULE) || defined (Mouse_CURRENT_MODULE)
		extern IDirectInput8W *	OS_di_object_ptr;
	#endif	// DINP_CURRENT_MODULE, Mouse_CURRENT_MODULE
#endif	// MODULE_OS



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef OS_CURRENT_HEADER
