/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (SLID_CURRENT_HEADER)
	#error Inclusion recursive du header SLID.
#endif
#define	SLID_CURRENT_HEADER

#if ! defined (SLID_HEADER_INCLUDED)
#define	SLID_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

enum
{
	SLID_DIRECTION_VERTICAL = 0,	/* Orientation des sliders */
	SLID_DIRECTION_HORIZONTAL
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	int		sbar_object;
	int		slider_object;
	int		pix_pos;
	int		pix_win;
	long		virtual_len;
	long		virtual_pos;
	long		virtual_win;
	signed int	glisse_pos;	/* -2: on a bouge en cliquant sur le cote, */
									/* -1: on n'a pas bouge, */
									/* 0-... : on est en train de glisser, offset de la souris par rapport au slider */
	int		direction;
	bool		changed_pos_flag;	/* Indique qu'on a change de position depuis la derniere fois */
	bool		no_graphic_limit_flag;	/* Indique qu'on n'est plus limite par le slider graphique mais par les limites suivantes */
	long		inf;
	long		sup;
} SLID_INFO;



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

void	SLID_display_slider (SLID_INFO *slider_ptr);
void	SLID_gere_slider (SLID_INFO *slider_ptr, int sel_object);
void	SLID_check_slider (SLID_INFO *slider_ptr);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SLID_CURRENT_HEADER
