/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (SPLH_CURRENT_HEADER)
	#error Inclusion recursive du header SPLH.
#endif
#define	SPLH_CURRENT_HEADER

#if ! defined (SPLH_HEADER_INCLUDED)
#define	SPLH_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"SWord24.h"

#include	<cstdio>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Conversion in-situ */
void	SPLH_convert_mem_8_2_16 (void *spl_ptr, LWORD length);
void	SPLH_convert_mem_16_2_8 (void *spl_ptr, LWORD length);
signed int	SPLH_convert_file_8_2_16 (FILE *file_ptr, int64_t data_offset, LWORD length);
signed int	SPLH_convert_file_16_2_8 (FILE *file_ptr, int64_t data_offset, LWORD length);
void	SPLH_convert_mem_mono_2_stereo (void *spl_ptr, LWORD length, int resol);
void	SPLH_convert_mem_stereo_2_mono (void *spl_ptr, LWORD length, int resol);
signed int	SPLH_convert_file_mono_2_stereo (FILE *file_ptr, int64_t data_offset, LWORD length, int resol);
signed int	SPLH_convert_file_stereo_2_mono (FILE *file_ptr, int64_t data_offset, LWORD length, int resol);

void	SPLH_convert_mem_24_2_flt (float dest_ptr [], const SLWORD src_ptr [], long length, long nbr_chn);
void	SPLH_convert_mem_flt_2_24 (SLWORD dest_ptr [], const float src_ptr [], long length, long nbr_chn);

/* Copie sans chevauchement avec conversion */
void	SPLH_copy_mem_8_stereo_2_24_stereo (SLWORD *dest_ptr, const SBYTE *src_ptr, LWORD length);
void	SPLH_copy_mem_8_stereo_2_24_bimono (SLWORD *dest_1_ptr, SLWORD *dest_2_ptr, const SBYTE *src_ptr, LWORD length);
void	SPLH_copy_mem_16_stereo_2_24_bimono (SLWORD *dest_1_ptr, SLWORD *dest_2_ptr, const SWORD *src_ptr, LWORD length);
float	SPLH_copy_mem_flt_stereo_2_8_stereo (SBYTE *dest_ptr, const float *src_ptr, LWORD length);
float	SPLH_copy_mem_flt_bimono_2_8_stereo (SBYTE *dest_ptr, const float *src_1_ptr, const float *src_2_ptr, LWORD length);
float	SPLH_copy_mem_flt_stereo_2_16_stereo (SWORD *dest_ptr, const float *src_ptr, LWORD length);
float	SPLH_copy_mem_flt_bimono_2_16_stereo (SWORD *dest_ptr, const float *src_1_ptr, const float *src_2_ptr, LWORD length);
float	SPLH_copy_mem_flt_stereo_2_24c_stereo (SWord24 *dest_ptr, const float *src_ptr, LWORD length);
float	SPLH_copy_mem_flt_bimono_2_24c_stereo (SWord24 *dest_ptr, const float *src_1_ptr, const float *src_2_ptr, LWORD length);
void	SPLH_copy_mem_invert_sample (void *dest_ptr, const void *src_ptr, LWORD length, int sample_mul);
void	SPLH_copy_mem_convert_sample_2_16 (SWORD *dest_ptr, const void *src_ptr, LWORD length, int channels, int src_resol);
void	SPLH_copy_mem_invert_convert_sample_2_16 (SWORD *dest_ptr, const void *src_ptr, LWORD length, int channels, int src_resol);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SPLH_CURRENT_HEADER
