/*****************************************************************************

        TestMidiFile.h
        Author: Laurent de Soras, 2022

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law.You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://www.wtfpl.net/ for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (TestMidiFile_HEADER_INCLUDED)
#define TestMidiFile_HEADER_INCLUDED



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include <vector>

#include <cstdint>



class MidiFileTrack;

class TestMidiFile
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	static int     perform_test ();



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	static int     load_file (std::vector <uint8_t> &content, const char filename_0 []);
	static void    print_track (const MidiFileTrack &track);



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               TestMidiFile ()                               = delete;
	               TestMidiFile (const TestMidiFile &other)      = delete;
	               TestMidiFile (TestMidiFile &&other)           = delete;
	TestMidiFile & operator = (const TestMidiFile &other)        = delete;
	TestMidiFile & operator = (TestMidiFile &&other)             = delete;
	bool           operator == (const TestMidiFile &other) const = delete;
	bool           operator != (const TestMidiFile &other) const = delete;

}; // class TestMidiFile



//#include "test/TestMidiFile.hpp"



#endif // TestMidiFile_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
