unit AboutDlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TAboutDialog = class(TForm)
    ProductNameL: TLabel;
    CopyrightL: TLabel;
    OKBitBtn: TBitBtn;
    ImagePanel: TPanel;
    Logo: TImage;
    Bevel: TBevel;
    ProductURLL: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ProductURLLClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutDialog: TAboutDialog;

procedure About;

implementation

uses MSConsts, ShellAPI;

{$R *.DFM}

procedure About;
begin
  with TAboutDialog.Create(Application) do
    try
      ShowModal;
    finally
      Free;
    end;
end;

procedure TAboutDialog.FormCreate(Sender: TObject);
begin
  Caption := 'About '+ProductName;
  ProductNameL.Caption := ProductName+' '+ProductVersion+
    ' (file format '+FileVersion+')';
  CopyrightL.Caption := Copyright;
  ProductURLL.Caption := ProductURL;
end;

procedure TAboutDialog.ProductURLLClick(Sender: TObject);
begin
  ShellExecute(Application.Handle,PChar('open'),PChar(ProductURL),PChar(''),nil,SW_NORMAL);
end;

end.
