unit EvEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Buttons, Song;

type
  TEventEditForm = class(TForm)
    SListLabel: TLabel;
    SListComboBox: TComboBox;
    NListLabel: TLabel;
    NListComboBox: TComboBox;
    VLabel: TLabel;
    VolLabel: TLabel;
    VolTrackBar: TTrackBar;
    PLabel: TLabel;
    PanLabel: TLabel;
    PanTrackBar: TTrackBar;
    OkBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    DVolCheckBox: TCheckBox;
    DPanCheckBox: TCheckBox;
    procedure VolTrackBarChange(Sender: TObject);
    procedure PanTrackBarChange(Sender: TObject);
    procedure DVolCheckBoxClick(Sender: TObject);
    procedure DPanCheckBoxClick(Sender: TObject);
    procedure SListComboBoxChange(Sender: TObject);
    procedure NListComboBoxChange(Sender: TObject);
  private
    { Private declarations }
    CC: TCommand;
    procedure Init(Song: TSong; C: TCommand);
    procedure UpdateVisual;
  public
    { Public declarations }
  end;

var
  EventEditForm: TEventEditForm;

function EditEvent(Song: TSong; var C: TCommand): Boolean;

implementation

uses MSConsts, Notes;

{$R *.DFM}

function EditEvent(Song: TSong; var C: TCommand): Boolean;
begin
  EventEditForm := TEventEditForm.Create(Application);
  with EventEditForm do
    try
      Init(Song, C);
      result := ShowModal=mrOk;
      C := CC;
    finally
      Free;
    end;
end;

procedure TEventEditForm.Init(Song: TSong; C: TCommand);
var i: Integer;
begin
  CC := C;
  if not (CC.Note in [0..MaxNote, NoNote, NoteCut, NoteOff]) then
    CC.Note := NoNote;
  if (CC.Instrument<0) or (CC.Instrument>Song.Samples.Count) then
    CC.Instrument := 0;
  if (CC.Volume>200) and (CC.Volume<>DVol) then
    CC.Volume := DVol;
  if ((CC.Pan<-100) or (CC.Pan>100)) and (CC.Pan<>DPan) then
    CC.Pan := DPan;
  SListComboBox.Items.Clear;
  SListComboBox.Items.Add('No instrument');
  for i := 1 to Song.Samples.Count do
    SListComboBox.Items.Add(Song.Samples[i].Name);
  NListComboBox.Items.Clear;
  NListComboBox.Items.Add(NoteToText(NoNote));
  NListComboBox.Items.Add(NoteToText(NoteCut));
  NListComboBox.Items.Add(NoteToText(NoteOff));
  for i := 0 to MaxNote do
    NListComboBox.Items.Add(NoteToText(i));
  UpdateVisual;
end;

procedure TEventEditForm.UpdateVisual;
begin
  if CC.Volume=DVol then
    begin
      DVolCheckBox.Checked := true;
      VolTrackBar.Enabled := false;
      VolTrackBar.Position := 100;
      VolLabel.Caption := '';
    end
  else
    begin
      DVolCheckBox.Checked := false;
      VolTrackBar.Enabled := true;
      VolTrackBar.Position := CC.Volume;
      VolLabel.Caption := IntToStr(CC.Volume);
    end;
  if CC.Pan=DPan then
    begin
      DPanCheckBox.Checked := true;
      PanTrackBar.Enabled := false;
      PanTrackBar.Position := 0;
      PanLabel.Caption := '';
    end
  else
    begin
      DPanCheckBox.Checked := false;
      PanTrackBar.Enabled := true;
      PanTrackBar.Position := CC.Pan;
      if CC.Pan=0 then
        PanLabel.Caption := 'C'
      else
      if CC.Pan>0 then
        PanLabel.Caption := IntToStr(Abs(CC.Pan))+' R'
      else
      if CC.Pan<0 then
        PanLabel.Caption := IntToStr(Abs(CC.Pan))+' L';
    end;
  SListComboBox.ItemIndex := CC.Instrument;
  if CC.Note = NoNote then NListComboBox.ItemIndex := 0
  else
  if CC.Note = NoteCut then NListComboBox.ItemIndex := 1
  else
  if CC.Note = NoteOff then NListComboBox.ItemIndex := 2
  else
  NListComboBox.ItemIndex := CC.Note+3;
end;

procedure TEventEditForm.VolTrackBarChange(Sender: TObject);
begin
  CC.Volume := VolTrackBar.Position;
  UpdateVisual;
end;

procedure TEventEditForm.PanTrackBarChange(Sender: TObject);
begin
  CC.Pan := PanTrackBar.Position;
  UpdateVisual;
end;

procedure TEventEditForm.DVolCheckBoxClick(Sender: TObject);
begin
  if DVolCheckBox.Checked then CC.Volume := DVol
  else CC.Volume := VolTrackBar.Position;
  UpdateVisual;
end;

procedure TEventEditForm.DPanCheckBoxClick(Sender: TObject);
begin
  if DPanCheckBox.Checked then CC.Pan := DPan
  else CC.Pan := PanTrackBar.Position;
  UpdateVisual;
end;

procedure TEventEditForm.SListComboBoxChange(Sender: TObject);
begin
  CC.Instrument := SListComboBox.ItemIndex;
  UpdateVisual;
end;

procedure TEventEditForm.NListComboBoxChange(Sender: TObject);
begin
  if NListComboBox.ItemIndex=0 then
    CC.Note := NoNote
  else
  if NListComboBox.ItemIndex=1 then
    CC.Note := NoteCut
  else
  if NListComboBox.ItemIndex=2 then
    CC.Note := NoteOff
  else CC.Note := NListComboBox.ItemIndex-3;
  UpdateVisual;
end;

end.
