unit Notes;

interface

uses Song;

function NoteToText(Note: Byte): String;
function CommandToText(Command: TCommand): String;
function KeyToNote(Key: Word): Byte;
function NoteCoef(Note: Byte): Double;

implementation

uses MSConsts, SysUtils, Windows, Math;

function NoteName(Note: Byte): String;
begin
  result := NoteNames[Note mod 12];
end;

function NoteToText(Note: Byte): String;
begin
  Case Note of
    NoNote: result := NoNoteText;
    NoteCut: result := NoteCutText;
    NoteOff: result := NoteOffText;
    else
      if Note>MaxNote then Raise Exception.Create('Invalid note')
      else result := NoteName(Note mod 12)+IntToStr(Note div 12);
  end;
end;

function IntToStrL(i, L: Integer): String;
begin
  result := IntToStr(i);
  while Length(result)<L do result := ' '+result;
end;

function CommandToText(Command: TCommand): String;
begin
  with Command do
    begin
      result := NoteToText(Note)+' ';
      if Instrument=0 then result := result+NoInstText
      else result := result+IntToStrL(Instrument, 4);
      result := result+' ';
      if Volume=DVol then result := result+NoVolText
      else result := result+IntToStrL(Volume, 3);
      result := result+' ';
      if Pan=DPan then result := result+NoPanText
      else
      if Pan=0 then result := result+'  C  '
      else
      if Pan<0 then result := result+IntToStrL(Abs(Pan), 3)+' L'
      else
      if Pan>0 then result := result+IntToStrL(Abs(Pan), 3)+' R';
    end;
end;

function KeyToNote(Key: Word): Byte;
var i: Integer; N: SmallInt;
begin
  result := InvKeyNote;
  case Key of
    VK_INSERT: result := NoteIns;
    VK_DELETE: result := NoteDel;
    VK_SPACE: result := NoNote;
    192: result := NoteCut;
    Ord('1'): result := NoteOff;
    VK_MULTIPLY: result := NoteOctUp;
    VK_DIVIDE: result := NoteOctDown;
    else
      begin
        for i := 1 to KeysNum do
          begin
            if Key=KeyTable[i].Key then
              begin
                N := BaseOctave*12+KeyTable[i].Ofs;
                if (N>=0) and (N<=MaxNote) then
                  result := N;
                Break;
              end;
          end;
      end;
  end;
end;

function NoteCoef(Note: Byte): Double;
begin
  if Note<=MaxNote then
    result := Power(2, (Note-BaseNote)/12)
  else result := 1;
end;

end.