unit SUtils;

interface

procedure Exec(Path, ComLine: String);
function GetTempName: String;

implementation

uses Windows, SysUtils;

procedure Exec(Path, ComLine: String);
var R: Boolean;
    ProcessInformation : TProcessInformation;
    StartupInfo : TStartupInfo;
begin
  FillChar(StartupInfo, sizeof(TStartupInfo), 0);
  with StartupInfo do begin
    cb := sizeof(TStartupInfo);
    dwFlags := STARTF_USESHOWWINDOW;
    wShowWindow := SW_SHOWNORMAL;
  end;

  R := CreateProcess(
         PChar(Path),
         PChar(Path+' '+ComLine),
         nil,
         nil,
         false,
         NORMAL_PRIORITY_CLASS,
         nil,
         nil,
         StartupInfo,
         ProcessInformation);
  if not R then RaiseLastWin32Error;
  WaitForSingleObject(ProcessInformation.hProcess, INFINITE);
end;

function GetTempName: String;
var TPNB: PChar; TPNL: Integer;
    TFNB: Array[0..MAX_PATH] of Char;
begin
  TPNL := GetTempPath(0, nil);
  if TPNL=0 then RaiseLastWin32Error;
  TPNB := StrAlloc(TPNL);
  try
    GetTempPath(TPNL, TPNB);
    if GetTempFileName(TPNB, '', 0, TFNB)=0 then
      RaiseLastWin32Error;
    result := TFNB;
    UniqueString(result);
  finally
    StrDispose(TPNB);
  end;
end;

end.
