unit WM;

interface

uses AE;

type
  //Functions to get count of samples and sample
  TNextStepFunction = procedure of object;
  TGetSamplesCountFunction = function: Integer of object;
  TGetSampleFunction = procedure(Render: Boolean; SNum: Integer; var SL: SmallInt; var SR: SmallInt) of object;
  TSetSampleFunction = procedure(Render: Boolean; SL, SR: SmallInt) of object;
  TClipFunction = procedure(Render: Boolean; CV: Integer) of object;

  TWaveMixer = class
   private
    FAudioEngine: TAudioEngine;
    FNextStep: TNextStepFunction;
    FGetSamplesCount: TGetSamplesCountFunction;
    FGetSample: TGetSampleFunction;
    FSetSample: TSetSampleFunction;
    FClip: TClipFunction;
    function ReadData(Render: Boolean; DataPtr: PS16StereoArray; Count: Integer): Boolean;
   public
    constructor Create(AAudioEngine: TAudioEngine);
    destructor Destroy; override;
    property OnNextStep: TNextStepFunction
      read FNextStep write FNextStep;
    property OnGetSamplesCount: TGetSamplesCountFunction
      read FGetSamplesCount write FGetSamplesCount;
    property OnGetSample: TGetSampleFunction
      read FGetSample write FGetSample;
    property OnSetSample: TSetSampleFunction
      read FSetSample write FSetSample;
    property OnClip: TClipFunction
      read FClip write FClip;
  end;

implementation

uses SysUtils, Windows;

function TWaveMixer.ReadData(Render: Boolean; DataPtr: PS16StereoArray; Count: Integer): Boolean;
var i, j: Integer; SL, SR: SmallInt;
begin
  result := true;
  if not Assigned(FGetSamplesCount) or not Assigned(FGetSample) then
    begin
      result := false;
      Exit;
    end;
  for j := 1 to Count do
    begin
      if Assigned(FNextStep) then FNextStep;
      if FGetSamplesCount=0 then
        begin
          result := j>1;
          if not result then Exit;
        end;
      DataPtr^[j].L := 0;
      DataPtr^[j].R := 0;
      for i := 1 to FGetSamplesCount do
        begin
          FGetSample(Render, i, SL, SR);
          if DataPtr^[j].L+SL>32767 then
            begin
              DataPtr^[j].L := 32767;
              if Assigned(FClip) then FClip(Render, DataPtr^[j].L+SL);
            end
          else
          if DataPtr^[j].L+SL<-32768 then
            begin
              DataPtr^[j].L := -32768;
              if Assigned(FClip) then FClip(Render, DataPtr^[j].L+SL);
            end
          else DataPtr^[j].L := DataPtr^[j].L+SL;

          if DataPtr^[j].R+SR>32767 then
            begin
              DataPtr^[j].R := 32767;
              if Assigned(FClip) then FClip(Render, DataPtr^[j].R+SR);
            end
          else
          if DataPtr^[j].R+SR<-32768 then
            begin
              DataPtr^[j].R := -32768;
              if Assigned(FClip) then FClip(Render, DataPtr^[j].R+SR);
            end
          else DataPtr^[j].R := DataPtr^[j].R+SR;
        end;
      if Assigned(FSetSample) then FSetSample(Render, DataPtr^[j].L, DataPtr^[j].R);
//      Sleep(1);
    end;
end;

constructor TWaveMixer.Create(AAudioEngine: TAudioEngine);
begin
  inherited Create;
  FAudioEngine := AAudioEngine;
  if not Assigned(FAudioEngine) then
    Raise Exception.Create('Audio engine not specified');
  FAudioEngine.OnReadData := ReadData;
end;

destructor TWaveMixer.Destroy;
begin
  if Assigned(FAudioEngine) then
    FAudioEngine.OnReadData := nil;
  inherited Destroy;
end;

end.