unit EvEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Buttons, Song;

type
  TEventEditForm = class(TForm)
    IListLabel: TLabel;
    IListComboBox: TComboBox;
    NListLabel: TLabel;
    NListComboBox: TComboBox;
    VLabel: TLabel;
    VelLabel: TLabel;
    VelTrackBar: TTrackBar;
    OkBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    DVelCheckBox: TCheckBox;
    procedure VelTrackBarChange(Sender: TObject);
    procedure DVelCheckBoxClick(Sender: TObject);
    procedure IListComboBoxChange(Sender: TObject);
    procedure NListComboBoxChange(Sender: TObject);
  private
    { Private declarations }
    CC: TCommand;
    procedure Init(Song: TSong; C: TCommand);
    procedure UpdateVisual;
  public
    { Public declarations }
  end;

var
  EventEditForm: TEventEditForm;

function EditEvent(Song: TSong; var C: TCommand): Boolean;

implementation

uses MSConsts, Notes;

{$R *.DFM}

function EditEvent(Song: TSong; var C: TCommand): Boolean;
begin
  EventEditForm := TEventEditForm.Create(Application);
  with EventEditForm do
    try
      Init(Song, C);
      result := ShowModal=mrOk;
      C := CC;
    finally
      Free;
    end;
end;

procedure TEventEditForm.Init(Song: TSong; C: TCommand);
var i: Integer;
begin
  CC := C;
  if not (CC.Note in [0..MaxNote, NoNote, NoteOff]) then
    CC.Note := NoNote;
  if (CC.Instrument<0) or (CC.Instrument>Song.Instruments.Count) then
    CC.Instrument := 0;
  if (CC.Velocity>127) and (CC.Velocity<>DVel) then
    CC.Velocity := DVel;
  IListComboBox.Items.Clear;
  for i := 1 to Song.Instruments.Count do
    IListComboBox.Items.Add(Song.Instruments[i].Name);
  NListComboBox.Items.Clear;
  NListComboBox.Items.Add(NoteToText(NoNote));
  NListComboBox.Items.Add(NoteToText(NoteOff));
  for i := 0 to MaxNote do
    NListComboBox.Items.Add(NoteToText(i));
  UpdateVisual;
end;

procedure TEventEditForm.UpdateVisual;
begin
  if CC.Velocity=DVel then
    begin
      DVelCheckBox.Checked := false;
      VelTrackBar.Enabled := false;
      VelTrackBar.Position := 127;
      VelLabel.Caption := '';
    end
  else
    begin
      DVelCheckBox.Checked := false;
      VelTrackBar.Enabled := true;
      VelTrackBar.Position := CC.Velocity;
      VelLabel.Caption := IntToStr(CC.Velocity);
    end;
  IListComboBox.ItemIndex := CC.Instrument-1;
  if CC.Note = NoNote then NListComboBox.ItemIndex := 0
  else
  if CC.Note = NoteOff then NListComboBox.ItemIndex := 1
  else
  NListComboBox.ItemIndex := CC.Note+2;
end;

procedure TEventEditForm.VelTrackBarChange(Sender: TObject);
begin
  CC.Velocity := VelTrackBar.Position;
  UpdateVisual;
end;

procedure TEventEditForm.DVelCheckBoxClick(Sender: TObject);
begin
  if DVelCheckBox.Checked then CC.Velocity := DVel
  else CC.Velocity := VelTrackBar.Position;
  UpdateVisual;
end;

procedure TEventEditForm.IListComboBoxChange(Sender: TObject);
begin
  CC.Instrument := IListComboBox.ItemIndex+1;
  UpdateVisual;
end;

procedure TEventEditForm.NListComboBoxChange(Sender: TObject);
begin
  if NListComboBox.ItemIndex=0 then
    CC.Note := NoNote
  else
  if NListComboBox.ItemIndex=1 then
    CC.Note := NoteOff
  else CC.Note := NListComboBox.ItemIndex-2;
  UpdateVisual;
end;

end.
