unit MSConsts;

interface

uses Graphics, MMSystem;

const
  K_DEFAULT=187;
  ProductName = 'MegaStation MIDI';
  ProductVersion = '0.11 beta';
  Copyright = 'Copyright (C) 2000, 2001 MegaStation team';
  ProductURL = 'http://megastation.euro.ru';
  FileSign = 'SNGM';
  FileVersion = '0.10';
  SongExt = 'msm';
  SongFilter = ProductName+' song file|*.'+SongExt;
  ClipboardFormat = ProductName+' pattern';
  DVel = 255;
  NoNote = 255;
  NoteOff = 253;
  MaxNote = 127;
  BaseNote = 60;
  InvKeyNote = 120;
  NoteIns = 121;
  NoteDel = 122;
  NoteOctUp = 123;
  NoteOctDown = 124;
  KeysNum = 37;

  BankSet = 0;
  AllNotesOff = 120;

type
  TColorSet = record
    PEditColorN: TColor;
    PEditColorNT: TColor;
    PEditColorS: TColor;
    PEditColorST: TColor;
    PEditColorB: TColor;
    PEditColorBT: TColor;
    PEditColorM: TColor;
    PEditColorMT: TColor;
    PEditColorL: TColor;
    SeqColorT: TColor;
    SeqColorP: TColor;
    SeqColorPT: TColor;
    SeqColorI: TColor;
    SeqColorIT: TColor;
  end;
  //Notes key table entry
  TKNRec = record Key: Word; Ofs: ShortInt end;
var
  StdColorSet: TColorSet =
    (
      PEditColorN: clSilver;
      PEditColorNT: clBlack;
      PEditColorS: clHighlight;
      PEditColorST: clHighlightText;
      PEditColorB: clDkGray;
      PEditColorBT: clWhite;
      PEditColorM: clDkGray-$1F1F1F;
      PEditColorMT: clWhite;
      PEditColorL: clBlack;
      SeqColorT: clSilver;
      SeqColorP: clSilver;
      SeqColorPT: clBlack;
      SeqColorI: clRed;
      SeqColorIT: clWhite;
    );
  AltColorSet: TColorSet =
    (
      PEditColorN: clBlack;
      PEditColorNT: clSilver;
      PEditColorS: clGreen+$001F00;
      PEditColorST: clYellow;
      PEditColorB: $5F0000;
      PEditColorBT: clWhite;
      PEditColorM: $7F0000;
      PEditColorMT: clWhite;
      PEditColorL: $FF0000;
      SeqColorT: $5F0000;
      SeqColorP: clGreen+$001F00;
      SeqColorPT: clBlack;
      SeqColorI: clRed;
      SeqColorIT: clWhite;
    );
  ColorSet: TColorSet;
  PPTick: Integer = 5;
  PPTrack: Integer = 20;
  TPFree: Integer = 10;
  TPEmpty: Integer = 5;
  EmptyP: String = 'Invalid';
  LoopPattern: Boolean = true;
  MidiDevice: Integer = MIDI_MAPPER;
  SFDevice: Integer = -1;
  FollowPattern: Boolean = true;
  FollowSong: Boolean = true;
  PlayWhileEdit: Boolean = true;

  //Notes
  BaseOctave: Byte = 5;
  Spacing: Integer = 1;
  NoNoteText: String = '---';
  NoteOffText: String = '^^^';
  NoInstText: String = '----';
  NoVelText: String = '---';

  //SF editor
  SFEditor: String;

  //Note key table
  KeyTable: Array[1..KeysNum] of TKNRec =
    (
      //Base octave +1 - main
      (Key: Ord('Q'); Ofs: 12),
      (Key: Ord('2'); Ofs: 12+1),
      (Key: Ord('W'); Ofs: 12+2),
      (Key: Ord('3'); Ofs: 12+3),
      (Key: Ord('E'); Ofs: 12+4),
      (Key: Ord('R'); Ofs: 12+5),
      (Key: Ord('5'); Ofs: 12+6),
      (Key: Ord('T'); Ofs: 12+7),
      (Key: Ord('6'); Ofs: 12+8),
      (Key: Ord('Y'); Ofs: 12+9),
      (Key: Ord('7'); Ofs: 12+10),
      (Key: Ord('U'); Ofs: 12+11),

      //Base octave +2
      (Key: Ord('I'); Ofs: 24),
      (Key: Ord('9'); Ofs: 24+1),
      (Key: Ord('O'); Ofs: 24+2),
      (Key: Ord('0'); Ofs: 24+3),
      (Key: Ord('P'); Ofs: 24+4),
      (Key: 219;      Ofs: 24+5),
      (Key: 187;      Ofs: 24+6),
      (Key: 221;      Ofs: 24+7),

      //Base octave
      (Key: Ord('Z'); Ofs: 0),
      (Key: Ord('S'); Ofs: 1),
      (Key: Ord('X'); Ofs: 2),
      (Key: Ord('D'); Ofs: 3),
      (Key: Ord('C'); Ofs: 4),
      (Key: Ord('V'); Ofs: 5),
      (Key: Ord('G'); Ofs: 6),
      (Key: Ord('B'); Ofs: 7),
      (Key: Ord('H'); Ofs: 8),
      (Key: Ord('N'); Ofs: 9),
      (Key: Ord('J'); Ofs: 10),
      (Key: Ord('M'); Ofs: 11),

      //Base octave +1 - secondary
      (Key: 188;      Ofs: 12),
      (Key: Ord('L'); Ofs: 12+1),
      (Key: 190;      Ofs: 12+2),
      (Key: 186;      Ofs: 12+3),
      (Key: 191;      Ofs: 12+4)
    );

  //Note name table
  NoteNames: Array[0..11] of String[2] =
  (
    'C ',
    'C#',
    'D ',
    'D#',
    'E ',
    'F ',
    'F#',
    'G ',
    'G#',
    'A ',
    'A#',
    'B '
  );

implementation

initialization
  ColorSet := StdColorSet;
end.
