unit OptForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Buttons, MSConsts, ColorGrd, ExtCtrls, SFMan;

type
  TOptionsForm = class(TForm)
    OptPageControl: TPageControl;
    OKBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    DeviceTabSheet: TTabSheet;
    DisplayTabSheet: TTabSheet;
    SCardComboBox: TComboBox;
    SCardLabel: TLabel;
    PEColorLabel: TLabel;
    ColorSetComboBox: TComboBox;
    CKindComboBox: TComboBox;
    CTestPanel: TPanel;
    MiscTabSheet: TTabSheet;
    EditorTabSheet: TTabSheet;
    SpacingLabel: TLabel;
    SpacingTrackBar: TTrackBar;
    SpcLabel: TLabel;
    BaseOctLabel: TLabel;
    BaseOctaveTrackBar: TTrackBar;
    BOLabel: TLabel;
    FollowPatternCheckBox: TCheckBox;
    FollowSongCheckBox: TCheckBox;
    PPTrackTrackBar: TTrackBar;
    PPTickTrackBar: TTrackBar;
    TPEmptyTrackBar: TTrackBar;
    TPFreeTrackBar: TTrackBar;
    PPTrackLabel: TLabel;
    PPTrLabel: TLabel;
    PPTickLabel: TLabel;
    PPTiLabel: TLabel;
    TPEmptyLabel: TLabel;
    TPELabel: TLabel;
    TPFreeLabel: TLabel;
    TPFLabel: TLabel;
    ColorDialog: TColorDialog;
    FGCButton: TButton;
    BGCButton: TButton;
    CKindLabel: TLabel;
    ApplyButton: TButton;
    ApplicationOpenDialog: TOpenDialog;
    PlayWhileEditCheckBox: TCheckBox;
    SFDeviceLabel: TLabel;
    SFDeviceComboBox: TComboBox;
    SFEditorLabel: TLabel;
    SFEditorSpeedButton: TSpeedButton;
    SFEditorEdit: TEdit;
    procedure BaseOctaveTrackBarChange(Sender: TObject);
    procedure SpacingTrackBarChange(Sender: TObject);
    procedure PPTrackTrackBarChange(Sender: TObject);
    procedure PPTickTrackBarChange(Sender: TObject);
    procedure TPEmptyTrackBarChange(Sender: TObject);
    procedure TPFreeTrackBarChange(Sender: TObject);
    procedure ApplyButtonClick(Sender: TObject);
    procedure CKindComboBoxChange(Sender: TObject);
    procedure FGCButtonClick(Sender: TObject);
    procedure BGCButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SFEditorSpeedButtonClick(Sender: TObject);
  private
    { Private declarations }
    CS: TColorSet;
    procedure UpdateColor;
  public
    { Public declarations }
  end;

var
  OptionsForm: TOptionsForm;
  FSFMan: TSFMan;

function SetOptions: Boolean;

implementation

uses Notes, MMSystem;

{$R *.DFM}

function SetOptions: Boolean;
begin
  OptionsForm := TOptionsForm.Create(Application);
  with OptionsForm do
    try
      result := ShowModal=mrOk;
    finally
      Free;
    end;
end;

procedure TOptionsForm.BaseOctaveTrackBarChange(Sender: TObject);
begin
  BOLabel.Caption := IntToStr(BaseOctaveTrackBar.Position)
end;

procedure TOptionsForm.SpacingTrackBarChange(Sender: TObject);
begin
  SpcLabel.Caption := IntToStr(SpacingTrackBar.Position);
end;

procedure TOptionsForm.PPTrackTrackBarChange(Sender: TObject);
begin
  PPTrLabel.Caption := IntToStr(PPTrackTrackBar.Position)+' pixels';
end;

procedure TOptionsForm.PPTickTrackBarChange(Sender: TObject);
begin
  PPTiLabel.Caption := IntToStr(PPTickTrackBar.Position)+' pixels';
end;

procedure TOptionsForm.TPEmptyTrackBarChange(Sender: TObject);
begin
  TPELabel.Caption := IntToStr(TPEmptyTrackBar.Position)+' ticks';
end;

procedure TOptionsForm.TPFreeTrackBarChange(Sender: TObject);
begin
  TPFLabel.Caption := IntToStr(TPFreeTrackBar.Position)+' ticks';
end;

procedure TOptionsForm.ApplyButtonClick(Sender: TObject);
begin
  if ColorSetComboBox.ItemIndex=0 then
    CS := StdColorSet
  else
  if ColorSetComboBox.ItemIndex=1 then
    CS := AltColorSet;
  UpdateColor;
end;

procedure TOptionsForm.UpdateColor;
begin
  with CKindComboBox do
    case ItemIndex of
      0: //Normal
        begin
          BGCButton.Enabled := true;
          FGCButton.Enabled := true;
          CTestPanel.Color := CS.PEditColorN;
          CTestPanel.Font.Color := CS.PEditColorNT;
        end;
      1: //Selected
        begin
          BGCButton.Enabled := true;
          FGCButton.Enabled := true;
          CTestPanel.Color := CS.PEditColorS;
          CTestPanel.Font.Color := CS.PEditColorST;
        end;
      2: //Beat
        begin
          BGCButton.Enabled := true;
          FGCButton.Enabled := true;
          CTestPanel.Color := CS.PEditColorB;
          CTestPanel.Font.Color := CS.PEditColorBT;
        end;
      3: //Measure
        begin
          BGCButton.Enabled := true;
          FGCButton.Enabled := true;
          CTestPanel.Color := CS.PEditColorM;
          CTestPanel.Font.Color := CS.PEditColorMT;
        end;
      4: //Line
        begin
          BGCButton.Enabled := false;
          FGCButton.Enabled := true;
          CTestPanel.Color := CS.PEditColorL;
          CTestPanel.Font.Color := CS.PEditColorL;
        end;
      5: //Track
        begin
          BGCButton.Enabled := false;
          FGCButton.Enabled := true;
          CTestPanel.Color := CS.SeqColorT;
          CTestPanel.Font.Color := CS.SeqColorT;
        end;
      6: //Pattern
        begin
          BGCButton.Enabled := true;
          FGCButton.Enabled := true;
          CTestPanel.Color := CS.SeqColorP;
          CTestPanel.Font.Color := CS.SeqColorPT;
        end;
      7: //Invalid
        begin
          BGCButton.Enabled := true;
          FGCButton.Enabled := true;
          CTestPanel.Color := CS.SeqColorI;
          CTestPanel.Font.Color := CS.SeqColorIT;
        end;
    end;
end;

procedure TOptionsForm.CKindComboBoxChange(Sender: TObject);
begin
  UpdateColor;
end;

procedure TOptionsForm.FGCButtonClick(Sender: TObject);
var C: TColor;
begin
  C := 0;
  with CKindComboBox do
    begin
      case ItemIndex of
        0: //Normal
          C := CS.PEditColorNT;
        1: //Selected
          C := CS.PEditColorST;
        2: //Beat
          C := CS.PEditColorBT;
        3: //Measure
          C := CS.PEditColorMT;
        4: //Line
          C := CS.PEditColorL;
        5: //Track
          C := CS.SeqColorT;
        6: //Pattern
          C := CS.SeqColorPT;
        7: //Invalid
          C := CS.SeqColorIT;
      end;
      ColorDialog.Color := C;
      if ColorDialog.Execute then
        begin
          C := ColorDialog.Color;
          with CKindComboBox do
            case ItemIndex of
              0: //Normal
                CS.PEditColorNT := C;
              1: //Selected
                CS.PEditColorST := C;
              2: //Beat
                CS.PEditColorBT := C;
              3: //Measure
                CS.PEditColorMT := C;
              4: //Line
                CS.PEditColorL := C;
              5: //Track
                CS.SeqColorT := C;
              6: //Pattern
                CS.SeqColorPT := C;
              7: //Invalid
                CS.SeqColorIT := C;
            end;
            UpdateColor;
        end;
    end;
end;

procedure TOptionsForm.BGCButtonClick(Sender: TObject);
var C: TColor;
begin
  C := 0;
  with CKindComboBox do
    begin
      case ItemIndex of
        0: //Normal
          C := CS.PEditColorN;
        1: //Selected
          C := CS.PEditColorS;
        2: //Beat
          C := CS.PEditColorB;
        3: //Measure
          C := CS.PEditColorM;
        4: //Line
          C := CS.PEditColorL;
        5: //Track
          C := CS.SeqColorT;
        6: //Pattern
          C := CS.SeqColorP;
        7: //Invalid
          C := CS.SeqColorI;
      end;
      ColorDialog.Color := C;
      if ColorDialog.Execute then
        begin
          C := ColorDialog.Color;
          with CKindComboBox do
            case ItemIndex of
              0: //Normal
                CS.PEditColorN := C;
              1: //Selected
                CS.PEditColorS := C;
              2: //Beat
                CS.PEditColorB := C;
              3: //Measure
                CS.PEditColorM := C;
              4: //Line
                CS.PEditColorL := C;
              5: //Track
                CS.SeqColorT := C;
              6: //Pattern
                CS.SeqColorP := C;
              7: //Invalid
                CS.SeqColorI := C;
            end;
            UpdateColor;
        end;
    end;
end;

procedure TOptionsForm.FormCreate(Sender: TObject);
var MC: TMidiOutCaps; i: Integer;
begin
  OptPageControl.ActivePage := DeviceTabSheet;
  //Sound card
  SCardComboBox.Items.Add('MIDI mapper');
  for i := 0 to midiOutGetNumDevs-1 do
    begin
      midiOutGetDevCaps(i, @MC, SizeOf(MC));
      SCardComboBox.Items.Add(MC.szPname);
    end;
  if MidiDevice=MIDI_MAPPER then SCardComboBox.ItemIndex := 0
  else SCardComboBox.ItemIndex := MidiDevice+1;
  SFDeviceComboBox.Items.Add('No Sound Font device');
  if Assigned(FSFMan) then
    for i := 0 to FSFMan.GetNumDevs-1 do
      SFDeviceComboBox.Items.Add(FSFMan.DevName(i));
  SFDeviceComboBox.ItemIndex := SFDevice+1;
  //Color
  CS := ColorSet;
  ColorSetComboBox.ItemIndex := 0;
  CKindComboBox.ItemIndex := 0;
  UpdateColor;
  //Editor
  BaseOctaveTrackBar.Position := BaseOctave;
  BaseOctaveTrackBarChange(BaseOctaveTrackBar);
  SpacingTrackBar.Position := Spacing;
  SpacingTrackBarChange(SpacingTrackBar);
  FollowPatternCheckBox.Checked := FollowPattern;
  FollowSongCheckBox.Checked := FollowSong;
  PlayWhileEditCheckBox.Checked := PlayWhileEdit;
  PPTrackTrackBar.Position := PPTrack;
  PPTrackTrackBarChange(PPTrackTrackBar);
  PPTickTrackBar.Position := PPTick;
  PPTickTrackBarChange(PPTickTrackBar);
  TPEmptyTrackBar.Position := TPEmpty;
  TPEmptyTrackBarChange(TPEmptyTrackBar);
  TPFreeTrackBar.Position := TPFree;
  TPFreeTrackBarChange(TPFreeTrackBar);
  //Misc
  SFEditorEdit.Text := SFEditor;
end;

procedure TOptionsForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if ModalResult<>mrOk then Exit;
  //Sound card
  if SCardComboBox.ItemIndex=0 then MidiDevice := MIDI_MAPPER
  else MidiDevice := SCardComboBox.ItemIndex-1;
  SFDevice := SFDeviceComboBox.ItemIndex-1;
  //Color
  ColorSet := CS;
  //Editor
  BaseOctave := BaseOctaveTrackBar.Position;
  Spacing := SpacingTrackBar.Position;
  FollowPattern := FollowPatternCheckBox.Checked;
  FollowSong := FollowSongCheckBox.Checked;
  PlayWhileEdit := PlayWhileEditCheckBox.Checked;
  PPTrack := PPTrackTrackBar.Position;
  PPTick := PPTickTrackBar.Position;
  TPEmpty := TPEmptyTrackBar.Position;
  TPFree := TPFreeTrackBar.Position;
  //Misc
  SFEditor := SFEditorEdit.Text;
end;

procedure TOptionsForm.SFEditorSpeedButtonClick(Sender: TObject);
begin
  ApplicationOpenDialog.FileName := SFEditorEdit.Text;
  if ApplicationOpenDialog.Execute then
    SFEditorEdit.Text := ApplicationOpenDialog.FileName;
end;

end.
