//********************************************//
// this file is a translation of SFMAH.H file //
//********************************************//

// This is the sfman.h header file which is part of the SFMS (see below)
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   SFMAN.H                                                               //
//                                                                         //
//   Description : Header file for acccesing the SoundFont Master Manager  //
//                                                                         //
//   Copyright (c) Creative Technology Ltd. / E-mu Systems, Inc.           //
//                 1996-1997. All rights reserved.                         //
//                                                                         //
//   Notes:        This header file is INDEPENDENT of the 'SFDEVMAN.H'     //
//                 header file. Any similarities in the prototypes or      //
//                 data values should be viewed as purely coincidental.    //
//                                                                         //
//   Revision:     1.01                                                    //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////


unit sfman_h;

interface

///// W I N D O W S   I N C L U D E S  //////////////////////////////////////

uses
  windows;

///// E R R O R  C O D E S  /////////////////////////////////////////////////

(*
    The following is a comprehensive list of the API error message values
*)

(*
--------------------------------
      Error Category
--------------------------------
*)

const     SFERR_BASE_INVALID             = 100;
const     SFERR_BASE_CONTENTION          = 200;
const     SFERR_BASE_API                 = 400;
const     SFERR_BASE_EXIT                = 800;
const     SFERR_BASE_UNDEFINE            = 900;

(*
--------------------------------
      General Error Messages
--------------------------------
*)

const     SFERR_NOERR                      = 0;
const     SFERR_UNDEFINE_ERROR             = ( SFERR_BASE_UNDEFINE + 1 );

(*
--------------------------------
   API Error Messages
--------------------------------
*)

const     SFERR_LOAD_DLL_FAIL            = ( SFERR_BASE_API + 1 );
const     SFERR_GET_ENTRYPOINT_FAIL      = ( SFERR_BASE_API + 2 );
const     SFERR_DEVICE_NOT_FOUND         = ( SFERR_BASE_API + 3 );
const     SFERR_INTERFACE_NOT_SUPPORTED  = ( SFERR_BASE_API + 4 );
const     SFERR_LAST_API                 = ( SFERR_BASE_API + 5 );

(*
--------------------------------
   Invalid Error Messages
--------------------------------
*)

const     SFERR_SYNTH_INVALID            = ( SFERR_BASE_INVALID + 5 );
const     SFERR_BANK_INDEX_INVALID       = ( SFERR_BASE_INVALID + 6 );
const     SFERR_PATHNAME_INVALID         = ( SFERR_BASE_INVALID + 7 );
const     SFERR_FORMAT_INVALID           = ( SFERR_BASE_INVALID + 8 );
const     SFERR_PRESET_INDEX_INVALID     = ( SFERR_BASE_INVALID + 9 );
const     SFERR_ACCESS_NOT_PERMITTED     = ( SFERR_BASE_INVALID + 11 );
const     SFERR_VERSION_INVALID          = ( SFERR_BASE_INVALID + 12 );
const     SFERR_DEVICE_INVALID           = ( SFERR_BASE_INVALID + 13 );
const     SFERR_SUPPORT_INVALID          = ( SFERR_BASE_INVALID + 14 );
const     SFERR_INVALID_SOUND_ROM        = ( SFERR_BASE_INVALID + 15 );
const     SFERR_NOT_STATIC_MEMORY        = ( SFERR_BASE_INVALID + 16 );
const     SFERR_LAST_INVALID             = ( SFERR_BASE_INVALID + 17 );

(*
--------------------------------
   Contention Error Messages
--------------------------------
*)

const     SFERR_DLL_BUSY                 = ( SFERR_BASE_CONTENTION + 1 );
const     SFERR_DEVICE_BUSY              = ( SFERR_BASE_CONTENTION + 2 );
const     SFERR_RESOURCE_INSUFFICIENT    = ( SFERR_BASE_CONTENTION + 3 );
const     SFERR_SYSMEM_INSUFFICIENT      = ( SFERR_BASE_CONTENTION + 4 );
const     SFERR_SOUNDMEM_INSUFFICIENT    = ( SFERR_BASE_CONTENTION + 5 );
const     SFERR_LAST_CONTENTION          = ( SFERR_BASE_CONTENTION + 6 );



///////////////////////////////////////////////////////////////////////////////////
//  S U P P O R T E D   I N T E R F A C E     I D                              //
///////////////////////////////////////////////////////////////////////////////////

// Currently supported Interface ID

type INTERFACEID = dword;

const    ID_SFMANL100API = $00010000;
const    ID_SFMANL101API = $00010001;


///////////////////////////////////////////////////////////////////////////////////
//  D A T A   S T R U C T U R E S   A N D   E N U M E R A T I O N   T A B L E S  //
///////////////////////////////////////////////////////////////////////////////////

/////  E N U M  /////

type
  SFBANKSTYLE = set of (
    (* Style 0, and the many names that go along with it... *)
    SFBANK_AWE32,
    (* Style 1, and the many names that go along with it... *)
    SFBANK_MMA
  );

const
  SFBANK_CC0_ONLY = SFBANK_AWE32;
  SFBANK_GS       = SFBANK_AWE32;
  SFBANK_DEFAULT  = SFBANK_AWE32;
  SFBANK_CC0_CC32 = SFBANK_MMA;

type PSFBANKSTYLE = ^SFBANKSTYLE;

type
  SFFLAG_OPERATION = set of (
    SFFLAG_OPER_FILE,
    SFFLAG_OPER_MEMORY
  );

type SFMANCAPS = dword;

const
  SFMANCAP_DYNAMIC_MEM_CAP            = $80000000;
  SFMANCAP_SOFTWARE_SYNTH_CAP         = $40000000;
  SFMANCAP_NONMMSYSTEM_COMPATIBLE_CAP = $20000000;
  SFMANCAP_NONWAVEFORM_SUPPORT_CAP    = $10000000;


///// S T R U C T /////

(*
This CSFMIDILocation is usually used when required to MIDI bank/preset
locaions to the DLL. The PSFPARAMOBJECT type define a pointer to the
parameter object.
*)

type
  CSFMIDILocation = record
    m_BankIndex:word;
    m_PresetIndex:word;
  end;
  SFMIDILOCATION = CSFMIDILocation;
  PSFMIDILOCATION = ^CSFMIDILocation;

(*
The CSFBufferObject is used to specify a buffer area to the DLL. This buffer
area will usually be filled with some strings or values. In some occassions,
the buffer itself, actually carries information to the DLL, like filename
etc. The PSFBUFFEROBJECT type define a pointer to the buffer object.
*)

type
  CSFBufferObject = record
    m_Size        :dword;     (* The size of the buffer attached *)
    m_Buffer      :pChar;     (* The pointer to the buffer itself *)
    m_SizeUsed    :dword;     (* The number of buffer characters used by DLL *)
    m_Flag        :word;      (* Scratch Variable *)
  end;
  PSFBUFFEROBJECT = ^CSFBufferObject;

(*
The CSFCapsObject is used to for querying device capabilities. This buffer
area will be filled with the capabilities of a particular SoundFont Device.
The PSFCAPSOBJECT type define a pointer to the device object.
*)

type
  CSFCapsObject = record
    m_SizeOf       :word;                   (* sizeof this structure                    *)
    m_RouterID     :dword;                  (* SF Device Router ID                      *)
    m_DevCaps      :dword;                  (* Capabilities                             *)
    m_MoreDevCaps  :dword;                  (* More capabilities                        *)
    m_RomID        :dword;                  (* ID for a Sound ROM used in a device      *)
    m_RomVer       :dword;                  (* Version for a Sound ROM used in a device *)
    m_DevName      :array [0..39] of char;  (* MMSystem name for MIDI Output Device     *)
    m_DevMgrName   :array [0..19] of char;  (* File Name of the Device Manager DLL.     *)
    m_DevMgrEntry  :array [0..19] of char;  (* Entry point inside the Device Manager DLL*)
  end;
  PSFCAPSOBJECT = ^CSFCapsObject;

/////  D E F I N E S  ///////////////////////////////////////////////////////

const SF_MASTER_MANAGER_FILENAME = 'SFMAN32.DLL';
const SF_FUNCTION_TABLE_NAME     = 'SFManager';

procedure SFMAN_GET_ROUTING_INDEX( dwID:dword; var by1, by2, by3, by4:byte );

const SFMAN_PERCUSSIVE_BANK = 128;//$8000;

/////  S F M A N   F u n c t i o n   T a b l e   ////////////////////////////

type SFDEVINDEX = word;

type
  SFMANAGERTAG = record
    SF_QueryInterface:function( p1:INTERFACEID; p2:PDWORD ):LRESULT;CDECL;
  end;
  SFMANAGER = SFMANAGERTAG;
  PSFMANAGER = ^SFMANAGERTAG;

type
  SFMANL101TAG = record

    // Global functions
    SF_GetNumDevs       :function( p1:PWORD ):LRESULT;CDECL;

    // Device functions which do not require allocation (opening)
    SF_GetDevCaps       :function( p1:SFDEVINDEX; p2:PSFCAPSOBJECT ):LRESULT;CDECL;
    SF_GetRouterID      :function( p1:SFDEVINDEX; p2:PDWORD ):LRESULT;CDECL;
    SF_IsDeviceFree     :function( p1:SFDEVINDEX ):LRESULT;CDECL;
    SF_Open             :function( p1:SFDEVINDEX ):LRESULT;CDECL;
    SF_Close            :function( p1:SFDEVINDEX ):LRESULT;CDECL;

    // Query functions
    SF_IsMIDIBankUsed              :function( p1:SFDEVINDEX; p2:PWORD ):LRESULT;CDECL;
    SF_QueryStaticSampleMemorySize :function( p1:SFDEVINDEX; p2:PDWORD; p3:PDWORD ):LRESULT;CDECL;

    // Synthesizer Emulation Functions
    SF_GetAllSynthEmulations  :function( p1:SFDEVINDEX; p2:PSFBUFFEROBJECT ):LRESULT;CDECL;
    SF_GetSynthEmulation      :function( p1:SFDEVINDEX; p2:PSFBUFFEROBJECT ):LRESULT;CDECL;
    SF_SelectSynthEmulation   :function( p1:SFDEVINDEX; p2:WORD ):LRESULT;CDECL;

    // Sound Bank management functions
    SF_LoadBank                 :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION; p3:PSFBUFFEROBJECT ):LRESULT;CDECL;
    SF_GetLoadedBankDescriptor  :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION; p3:PSFBUFFEROBJECT ):LRESULT;CDECL;
    SF_GetLoadedBankPathname    :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION; p3:PSFBUFFEROBJECT ):LRESULT;CDECL;
    SF_ClearLoadedBank          :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION ):LRESULT;CDECL;

    // Sound Preset management functions
    SF_LoadPreset                  :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION; p3:PSFMIDILOCATION; p4:PSFBUFFEROBJECT ):LRESULT;CDECL;
    SF_GetLoadedPresetDescriptor   :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION; p3:PSFBUFFEROBJECT ):LRESULT;CDECL;
    SF_ClearLoadedPreset           :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION ):LRESULT;CDECL;

    // Sound Waveform management functions
    SF_LoadWaveform         :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION; p3:PSFBUFFEROBJECT ):LRESULT;CDECL;
    SF_ClearLoadedWaveform  :function( p1:SFDEVINDEX; p2:PSFMIDILOCATION ):LRESULT;CDECL;

    // Device Specific Message
    SF_DeviceSpecificMessage :function( p1:SFDEVINDEX; p2:UINT; p3:LPARAM; p4:LPARAM ):LRESULT;CDECL;
  end;
  SFMANL101API = SFMANL101TAG;
  PSFMANL101API = ^SFMANL101TAG;

implementation

procedure SFMAN_GET_ROUTING_INDEX( dwID:dword; var by1, by2, by3, by4:byte );
begin
     by1 := BYTE( ( dwID ) and $7F );
     by2 := BYTE( ( dwID shr 8) and $7F );
     by3 := BYTE( ( dwID shr 16) and $7F );
     by4 := BYTE( ( dwID shr 24) and $7F );
end;

end.

