unit Transp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;

type
  TTransposeForm = class(TForm)
    OKBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    TrSignLabel: TLabel;
    TrSignPanel: TPanel;
    TrUpRadioButton: TRadioButton;
    TrDownRadioButton: TRadioButton;
    TrUnitPanel: TPanel;
    TrSemRadioButton: TRadioButton;
    TrOctRadioButton: TRadioButton;
    TrNumEdit: TEdit;
    procedure TrNumEditChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TrSemRadioButtonClick(Sender: TObject);
    procedure TrOctRadioButtonClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
    FSemitones: Integer;
    FValue: Integer;
  public
    { Public declarations }
  end;

var
  TransposeForm: TTransposeForm;

function GetTranspose: Integer;

implementation

uses MSConsts;

{$R *.DFM}

function GetTranspose: Integer;
begin
  with TTransposeForm.Create(Application) do
    try
      if ShowModal=mrOk then
        result := FSemitones
      else result := 0;
    finally
      Free;
    end;
end;

procedure TTransposeForm.TrNumEditChange(Sender: TObject);
begin
  try
    FValue := StrToInt(TrNumEdit.Text);
  except
    TrNumEdit.Text := IntToStr(FValue);
  end;
end;

procedure TTransposeForm.FormCreate(Sender: TObject);
begin
  FValue := 0;
  TrNumEdit.Text := IntToStr(FValue);
end;

procedure TTransposeForm.TrSemRadioButtonClick(Sender: TObject);
begin
  FValue := FValue*12;
  TrNumEdit.Text := IntToStr(FValue);
end;

procedure TTransposeForm.TrOctRadioButtonClick(Sender: TObject);
begin
  FValue := FValue div 12;
  TrNumEdit.Text := IntToStr(FValue);
end;

procedure TTransposeForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
var i: Integer;
begin
  CanClose := true;
  FSemitones := 0;
  if ModalResult<>mrOk then Exit;
  i := FValue;
  if TrOctRadioButton.Checked then i := i*12;
  if (i<0) or (i>MaxNote) then
    begin
      MessageDlg('Cannot transpose for more than '+
        IntToStr(MaxNote)+' semitones', mtWarning, [mbOk], 0);
      CanClose := false;
    end;
  if TrDownRadioButton.Checked then i := -i;
  FSemitones := i;
end;

end.
