unit XClpBrd;

interface

procedure SetClipboardStr(Format: Word; Buffer: String);
function GetClipboardStr(Format: Word): String;

implementation

uses Windows, ClipBrd;

procedure SetClipboardStr(Format: Word; Buffer: String);
var
  Data: THandle;
  DataPtr: Pointer;
  i: Integer;
begin
  if Buffer='' then Exit;
  with Clipboard do
    begin
      i := Length(Buffer);
      Data := GlobalAlloc(GMEM_MOVEABLE, i+SizeOf(Integer));
      try
        DataPtr := GlobalLock(Data);
        try
          Move(i, DataPtr^, SizeOf(Integer));
          Move(Buffer[1],
               Pointer(Integer(DataPtr)+SizeOf(Integer))^, i);
          SetAsHandle(Format, Data);
        finally
          GlobalUnlock(Data);
        end;
      except
        GlobalFree(Data);
        raise;
      end;
    end;
end;

function GetClipboardStr(Format: Word): String;
var
  Data: THandle;
  DataPtr: Pointer;
  i: Integer;
begin
  result := '';
  with Clipboard do
    begin
      if not HasFormat(Format) then Exit;
      Data := GetAsHandle(Format);
      DataPtr := GlobalLock(Data);
      try
        Move(DataPtr^, i, SizeOf(Integer));
        SetLength(result, i);
        Move(Pointer(Integer(DataPtr)+SizeOf(Integer))^,
             result[1], i);
      finally
        GlobalUnlock(Data);
      end;
    end;
end;

end.
