UNIT Globals;

INTERFACE

CONST ktQWERTY=0;
      ktQWERTZ=1;
      ktAZERTY=2;
      
VAR KeyboardType:INTEGER;

FUNCTION Hex2Str(I:BYTE):STRING;
FUNCTION ABC(I:BYTE):CHAR;
FUNCTION Hex2C(I:BYTE):STRING;
FUNCTION Note3C(I:BYTE):STRING;
FUNCTION Char2Note(C:CHAR;VAR N,O:INTEGER):BOOLEAN;

IMPLEMENTATION

CONST Hex:ARRAY[0..15] OF CHAR='0123456789ABCDEF';

FUNCTION Hex2Str(I:BYTE):STRING;
BEGIN
 RESULT:=Hex[(I SHR 4) AND $F]+Hex[I AND $F];
END;

FUNCTION ABC(I:BYTE):CHAR;
BEGIN
 RESULT:=CHR(ORD('A')+I-1);
 IF I>=27 THEN RESULT:=CHR(ORD('0')+I-27);
END;

FUNCTION Hex2C(I:BYTE):STRING;
BEGIN
 RESULT:=Hex[(I SHR 4) AND $F]+Hex[I AND $F];
END;

FUNCTION Note3C(I:BYTE):STRING;
VAR S:STRING;
    J:BYTE;
BEGIN
 S:='...';
 IF (I>0) AND (I<121) THEN BEGIN
  J:=(I-1) MOD 12;
  CASE J OF
   0:S:='C-';
   1:S:='C#';
   2:S:='D-';
   3:S:='D#';
   4:S:='E-';
   5:S:='F-';
   6:S:='F#';
   7:S:='G-';
   8:S:='G#';
   9:S:='A-';
   10:S:='A#';
   11:S:='B-';
  END;
  S:=S+HEX[((I-1) DIV 12) AND $F];
 END ELSE IF I=$FE THEN BEGIN
  S:='^^^';
 END ELSE IF I>=$80 THEN BEGIN
  S:='===';
 END;
 RESULT:=S;
END;

FUNCTION Char2Note(C:CHAR;VAR N,O:INTEGER):BOOLEAN;
BEGIN
 RESULT:=TRUE;
 CASE KeyboardType OF
  ktQWERTZ:BEGIN
   CASE C OF
    'Y':BEGIN N:=0;O:=O; END;
    'S':BEGIN N:=1;O:=O; END;
    'X':BEGIN N:=2;O:=O; END;
    'D':BEGIN N:=3;O:=O; END;
    'C':BEGIN N:=4;O:=O; END;
    'V':BEGIN N:=5;O:=O; END;
    'G':BEGIN N:=6;O:=O; END;
    'B':BEGIN N:=7;O:=O; END;
    'H':BEGIN N:=8;O:=O; END;
    'N':BEGIN N:=9;O:=O; END;
    'J':BEGIN N:=10;O:=O; END;
    'M':BEGIN N:=11;O:=O; END;
    'Q':BEGIN N:=0;O:=O+1; END;
    '2':BEGIN N:=1;O:=O+1; END;
    'W':BEGIN N:=2;O:=O+1; END;
    '3':BEGIN N:=3;O:=O+1; END;
    'E':BEGIN N:=4;O:=O+1; END;
    'R':BEGIN N:=5;O:=O+1; END;
    '5':BEGIN N:=6;O:=O+1; END;
    'T':BEGIN N:=7;O:=O+1; END;
    '6':BEGIN N:=8;O:=O+1; END;
    'Z':BEGIN N:=9;O:=O+1; END;
    '7':BEGIN N:=10;O:=O+1; END;
    'U':BEGIN N:=11;O:=O+1; END;
    'I':BEGIN N:=0;O:=O+2; END;
    '9':BEGIN N:=1;O:=O+2; END;
    'O':BEGIN N:=2;O:=O+2; END;
    '0':BEGIN N:=3;O:=O+2; END;
    'P':BEGIN N:=4;O:=O+2; END;
    '1':BEGIN N:=254;O:=-1; END;
    #221:BEGIN N:=252;O:=-1; END;
    ELSE RESULT:=FALSE;
   END;
  END;
  ktQWERTY:BEGIN
   CASE C OF
    'Z':BEGIN N:=0;O:=O; END;
    'S':BEGIN N:=1;O:=O; END;
    'X':BEGIN N:=2;O:=O; END;
    'D':BEGIN N:=3;O:=O; END;
    'C':BEGIN N:=4;O:=O; END;
    'V':BEGIN N:=5;O:=O; END;
    'G':BEGIN N:=6;O:=O; END;
    'B':BEGIN N:=7;O:=O; END;
    'H':BEGIN N:=8;O:=O; END;
    'N':BEGIN N:=9;O:=O; END;
    'J':BEGIN N:=10;O:=O; END;
    'M':BEGIN N:=11;O:=O; END;
    'Q':BEGIN N:=0;O:=O+1; END;
    '2':BEGIN N:=1;O:=O+1; END;
    'W':BEGIN N:=2;O:=O+1; END;
    '3':BEGIN N:=3;O:=O+1; END;
    'E':BEGIN N:=4;O:=O+1; END;
    'R':BEGIN N:=5;O:=O+1; END;
    '5':BEGIN N:=6;O:=O+1; END;
    'T':BEGIN N:=7;O:=O+1; END;
    '6':BEGIN N:=8;O:=O+1; END;
    'Y':BEGIN N:=9;O:=O+1; END;
    '7':BEGIN N:=10;O:=O+1; END;
    'U':BEGIN N:=11;O:=O+1; END;
    'I':BEGIN N:=0;O:=O+2; END;
    '9':BEGIN N:=1;O:=O+2; END;
    'O':BEGIN N:=2;O:=O+2; END;
    '0':BEGIN N:=3;O:=O+2; END;
    'P':BEGIN N:=4;O:=O+2; END;
    '1':BEGIN N:=254;O:=-1; END;
    #221:BEGIN N:=252;O:=-1; END;
    ELSE RESULT:=FALSE;
   END;
  END;
  ktAZERTY:BEGIN
   CASE C OF
    'W':BEGIN N:=0;O:=O; END;
    'S':BEGIN N:=1;O:=O; END;
    'X':BEGIN N:=2;O:=O; END;
    'D':BEGIN N:=3;O:=O; END;
    'C':BEGIN N:=4;O:=O; END;
    'V':BEGIN N:=5;O:=O; END;
    'G':BEGIN N:=6;O:=O; END;
    'B':BEGIN N:=7;O:=O; END;
    'H':BEGIN N:=8;O:=O; END;
    'N':BEGIN N:=9;O:=O; END;
    'J':BEGIN N:=10;O:=O; END;
    'K':BEGIN N:=11;O:=O; END;
    'A':BEGIN N:=0;O:=O+1; END;
    '2':BEGIN N:=1;O:=O+1; END;
    'Z':BEGIN N:=2;O:=O+1; END;
    '3':BEGIN N:=3;O:=O+1; END;
    'E':BEGIN N:=4;O:=O+1; END;
    'R':BEGIN N:=5;O:=O+1; END;
    '5':BEGIN N:=6;O:=O+1; END;
    'T':BEGIN N:=7;O:=O+1; END;
    '6':BEGIN N:=8;O:=O+1; END;
    'Y':BEGIN N:=9;O:=O+1; END;
    '7':BEGIN N:=10;O:=O+1; END;
    'U':BEGIN N:=11;O:=O+1; END;
    'I':BEGIN N:=0;O:=O+2; END;
    '9':BEGIN N:=1;O:=O+2; END;
    'O':BEGIN N:=2;O:=O+2; END;
    '0':BEGIN N:=3;O:=O+2; END;
    'P':BEGIN N:=4;O:=O+2; END;
    '1':BEGIN N:=254;O:=-1; END;
    #221:BEGIN N:=252;O:=-1; END;
    ELSE RESULT:=FALSE;
   END;
  END;
 END;
END;

END.
 