UNIT Oscil;

INTERFACE

USES Windows,Synth;

VAR TheSynthData:P4kSynthData;

PROCEDURE ClearOscil(hn:HWND);
PROCEDURE InitOscil(hn:HWND;tx,ty:LONGWORD);
PROCEDURE UnInitOscil;
PROCEDURE DoOscil(hn:HWND);

IMPLEMENTATION

VAR OscilOldImage,OscilImage,OscilH:HWND;
    OscilPBitmap:POINTER;
    OscilBackImage:POINTER;
    Txp,Typ,NLin,PLin:LONGWORD;

FUNCTION CreateDIBSection(hdc:HWND;bit:POINTER;usage:WORD;pnt:POINTER;truc:HWND;machin:LONGWORD):HWND; STDCALL EXTERNAL 'gdi32.dll' NAME 'CreateDIBSection';

PROCEDURE ClearOscil(hn:HWND);
BEGIN
 MOVE(Oscilbackimage^,Oscilpbitmap^,txp*typ);
 bitblt(hn,0,0,txp,typ,OscilH,0,0,SRCCOPY);
END;

PROCEDURE InitOscil(hn:HWND;tx,ty:LONGWORD);
TYPE tbi=RECORD
      bmiHeader:bitmapinfoheader;
      bmiColors:ARRAY[0..255] OF rgbquad;
     END;
VAR bminfo:tbi;
    I{,j}:WORD;
BEGIN
 txp:=tx;
 typ:=ty;
 plin:=(ty-2) div 7;
 plin:=(plin-1) div 2;
 nlin:=plin*2+1;
 bminfo.bmiHeader.bisize:=sizeof(tagBITMAPINFOHEADER);
 bminfo.bmiHeader.biwidth:=txp;
 bminfo.bmiHeader.biheight:=-typ;
 bminfo.bmiHeader.biplanes:=1;
 bminfo.bmiHeader.biBitCount:=8;
 bminfo.bmiHeader.bicompression:=bi_rgb;
 bminfo.bmiHeader.bisizeimage:=0;
 bminfo.bmiHeader.biXPelsPerMeter:=0;
 bminfo.bmiHeader.biYPelsPerMeter:=0;
 bminfo.bmiHeader.biclrused:=0;
 bminfo.bmiHeader.biClrImportant:=0;
 FOR I:=0 TO 15 DO BEGIN
  bminfo.bmicolors[I].rgbred:=((I SHR 3)*21+((I AND 4) SHR 2)*42)*3;
  bminfo.bmicolors[I].rgbgreen:=((I SHR 3)*21+((I AND 2) SHR 1)*42)*0;
  bminfo.bmicolors[I].rgbblue:=((I SHR 3)*21+((I AND 1) SHR 0)*42)*3;
 END;
 bminfo.bmicolors[253].rgbred:=$FF;
 bminfo.bmicolors[253].rgbgreen:=0;
 bminfo.bmicolors[253].rgbblue:=0;

 bminfo.bmicolors[254].rgbred:=$FF;
 bminfo.bmicolors[254].rgbgreen:=$FF;
 bminfo.bmicolors[254].rgbblue:=$7D;

 bminfo.bmicolors[255].rgbred:=$ff;
 bminfo.bmicolors[255].rgbgreen:=$ff;
 bminfo.bmicolors[255].rgbblue:=$ff;

 Oscilh:=CreateCompatibleDC(hn);
 Oscilimage:=createdibsection(0,@bminfo,DIB_RGB_COLORS,@Oscilpbitmap,0,0);
 Osciloldimage:=selectobject(Oscilh,Oscilimage);

 GETMEM(Oscilbackimage,txp*typ);
 FILLCHAR(Oscilbackimage^,txp*typ,#0);
 ClearOscil(hn);
END;

PROCEDURE UnInitOscil;
BEGIN
 FREEMEM(Oscilbackimage);
 selectobject(Oscilh,Osciloldimage);
 deleteobject(Oscilimage);
 deletedc(Oscilh);
END;

PROCEDURE DoOscil(hn:HWND);
LABEL NOP;
VAR pt:POINTER;
    I:BYTE;
    X,Y:WORD;
    U:LONGINT;
    SS,X2,Y2:LONGWORD;
    B:T4kOscil;
CONST col=254;
BEGIN
 pt:=Oscilpbitmap;
 MOVE(Oscilbackimage^,pt^,txp*typ);

 SS:=TXP*TYP;
 x2:=((TXP-128) DIV 2)+6;
 y2:=((TYP-128) DIV 2)+6;
 FOR I:=0 TO 15 DO BEGIN
  MOVE(TheSynthData^.Oscil[I],B,2048*4);
  FOR X:=1 TO 16 DO BEGIN
   U:=TRUNCINT((B[((X-1)*(2048 DIV 48))]+1)*10);
   Y:=U;
   IF ((X+X2)+(TXP*(Y+Y2)))<SS THEN BEGIN
    BYTE(POINTER(LONGWORD(pt)+(y+y2)*txp+(x+x2))^):=255;
   END;
  END;
  X2:=X2+32;
  IF (X2+32)>=TXP THEN BEGIN
   x2:=((TXP-128) DIV 2)+6;
   INC(Y2,32);
  END;
 END;
 bitblt(hn,0,0,txp,typ,OscilH,0,0,SRCCOPY);
END;

END.
