
Synthclean=0

.LIBRARY "winmm.dll"
IMPORT waveOutWrite "waveOutWrite"
IMPORT waveOutUnprepareHeader "waveOutUnprepareHeader"
IMPORT waveOutPrepareHeader "waveOutPrepareHeader"
IMPORT waveOutOpen "waveOutOpen"

.IF(Synthclean){
 IMPORT waveOutReset "waveOutReset"
 IMPORT waveOutClose "waveOutClose"
}

; [synth.pas]
; [109] END;
SYNTH_F_POWER$SINGLE$SINGLE:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para Number located at ebp+8
; Para Exponent located at ebp+12
; [99] FLD Exponent
		fld	dword [ebp+12]
; [100] FLD Number
		fld	dword [ebp+8]
; [101] FYL2X
		fyl2x
; [102] FLD1
		fld1
; [103] FLD ST(1)
		fld	st1
; [104] FPREM
		fprem
; [105] F2XM1
		f2xm1
; [106] FADDP ST(1),ST
		faddp	st1,st0
; [107] FSCALE
		fscale
; [108] FSTP ST(1)
		fstp	st1
		leave
		ret	8

; [113] BEGIN
SYNTH_WHITENOISERANDOM:
; Temps allocated between ebp-8 and ebp-8
		push	ebp
		mov	ebp,esp
		sub	esp,8
; Local $result located at ebp-4
; Local WhiteNoiseValue located at ebp-8
; [114] WhiteNoiseSeed:=(WhiteNoiseSeed*$524281)+$3133731;
		mov	edx,dword [U_SYNTH_WHITENOISESEED]
		mov	eax,5390977
		mul	edx
		add	eax,51590961
		mov	dword [U_SYNTH_WHITENOISESEED],eax
; [115] WhiteNoiseValue:=(WhiteNoiseSeed AND $7FFFFF) OR $40000000;
		and	eax,8388607
		or	eax,1073741824
		mov	dword [ebp-8],eax
; [116] RESULT:=SINGLE(POINTER(@WhiteNoiseValue)^)-3;
		lea	eax,[ebp-8]
		fld	dword [eax]
                fld     tword [SYNTHASM$40]
		fsubp	st1,st0
		fstp	dword [ebp-4]
; [117] END;
		fld	dword [ebp-4]
		leave
		ret

; [121] BEGIN
SYNTH_FRAC$SINGLE:
; Temps allocated between ebp-16 and ebp-8
		push	ebp
		mov	ebp,esp
		sub	esp,16
		mov	dword [ebp-16],esi
		mov	dword [ebp-12],edi
; Para X located at ebp+8
; Local $result located at ebp-4
; Local Y located at ebp-8
; [122] Y:=X;
		lea	edi,[ebp-8]
		lea	esi,[ebp+8]
		cld
		mov	ecx,4
		rep
		movsb
; [124] FLD DWORD PTR Y
		fld	dword [ebp-8]
; [125] FRNDINT
		frndint
; [126] FSTP DWORD PTR Y
		fstp	dword [ebp-8]
; [128] RESULT:=X-Y;
		fld	dword [ebp-8]
		fsubr	dword [ebp+8]
		fstp	dword [ebp-4]
; [129] END;
		fld	dword [ebp-4]
		mov	esi,dword [ebp-16]
		mov	edi,dword [ebp-12]
		leave
		ret	4

; [133] BEGIN
SYNTH_SYNTHREINIT$T4KSYNTHDATA:
SynthReinit:
; Temps allocated between ebp-8 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,8
		mov	dword [ebp-8],ebx
; Para SynthData located at ebp+8
; Local Channel located at ebp-4
; [134] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
		mov	dword [ebp-4],0
		dec	dword [ebp-4]
SYNTHASM$51:
		inc	dword [ebp-4]
; [135] IF SynthData.FileData.EventOffset[Channel]>=0 THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-4]
		mov	eax,dword [edx+eax*4+368]
		test	eax,eax
                jnge    NEAR SYNTHASM$55
; [136] SynthData.RealtimeData.EventOffset[Channel]:=POINTER(LONGWORD(@SynthData.EventData)+LONGWORD(SynthData.FileData.EventOffset[Channel]));
		mov	ecx,dword [ebp-4]
		lea	ebx,[edx+560]
		add	ebx,dword [edx+ecx*4+368]
		mov	dword [edx+ecx*4+2098864],ebx
; [137] SynthData.RealtimeData.NoteOffset[Channel]:=POINTER(LONGWORD(@SynthData.EventData)+LONGWORD(SynthData.FileData.NoteOffset[Channel]));
		lea	ebx,[edx+560]
		add	ebx,dword [edx+ecx*4+432]
		mov	dword [edx+ecx*4+2098928],ebx
; [138] SynthData.RealtimeData.VolumeOffset[Channel]:=POINTER(LONGWORD(@SynthData.EventData)+LONGWORD(SynthData.FileData.VolumeOffset[Channel]));
		lea	ebx,[edx+560]
		add	ebx,dword [edx+ecx*4+496]
		mov	dword [edx+ecx*4+2098992],ebx
; [139] SynthData.RealtimeData.TickCounter[Channel]:=0;
		mov	dword [edx+ecx*4+2098800],0
SYNTHASM$55:
		cmp	dword [ebp-4],15
                jl      NEAR SYNTHASM$51
; [142] END;
		mov	ebx,dword [ebp-8]
		leave
		ret	4

; [145] BEGIN
SYNTH_SYNTHRECALCFILTER$T4KFILTER:
SynthRecalcFilter:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para Filter located at ebp+8
; [146] WITH Filter DO BEGIN
		mov	eax,dword [ebp+8]
; [147] FBLP:=RLP+RLP/(1-CLP);
		fld	dword [eax+32]
		fld	dword [eax+32]
		fld	dword [eax+24]
		fld1
		fsubrp	st1,st0
		fdivp	st1,st0
		faddp	st1,st0
		fstp	dword [eax+16]
; [148] FBHP:=RHP+RHP/(1-CLP);
		fld	dword [eax+36]
		fld	dword [eax+36]
		fld	dword [eax+24]
		fld1
		fsubrp	st1,st0
		fdivp	st1,st0
		faddp	st1,st0
		fstp	dword [eax+20]
; [150] END;
		leave
		ret	4

; [154] BEGIN
SYNTH_SYNTHINITDATA$T4KSYNTHDATA:
SynthInitData:
; Temps allocated between ebp-12 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,12
		mov	dword [ebp-12],esi
		mov	dword [ebp-8],edi
; Para SynthData located at ebp+8
; Local Channel located at ebp-4
; [155] SynthReinit(SynthData);
		mov	eax,dword [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHREINIT$T4KSYNTHDATA
; [156] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
		mov	dword [ebp-4],0
		dec	dword [ebp-4]
SYNTHASM$76:
		inc	dword [ebp-4]
; [157] SynthData.RealtimeData.Filter[Channel].CLP:=CutOffLowPassStartValue;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-4]
		imul	eax,40
		lea	edi,[edx+eax+2098184]
                mov     esi,dword SYNTHASM$81
		cld
		mov	ecx,4
		rep
		movsb
; [158] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-4]
		imul	eax,40
		lea	eax,[edx+eax+2098160]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
		cmp	dword [ebp-4],15
                jl      NEAR SYNTHASM$76
; [160] END;
		mov	esi,dword [ebp-12]
		mov	edi,dword [ebp-8]
		leave
		ret	4

; [167] BEGIN
SYNTH_SYNTHFILLBUFFER$T4KSYNTHDATA$PSINGLE:
SynthFillBuffer:
; Temps allocated between ebp-72 and ebp-48
		push	ebp
		mov	ebp,esp
		sub	esp,72
		mov	dword [ebp-72],ebx
		mov	dword [ebp-68],esi
		mov	dword [ebp-64],edi
; Para SynthData located at ebp+8
; Para Buffer located at ebp+12
; Local Position located at ebp-4
; Local Channel located at ebp-8
; Local Count located at ebp-12
; Local WaveForm located at ebp-16
; Local Phase located at ebp-20
; Local Left located at ebp-24
; Local Right located at ebp-28
; Local PanningValue located at ebp-32
; Local OscValue located at ebp-36
; Local Value located at ebp-40
; Local Note located at ebp-44
; Local Volume located at ebp-48
; [168] FOR Position:=1 TO BufferSize DO BEGIN
		mov	dword [ebp-4],1
		dec	dword [ebp-4]
SYNTHASM$116:
		inc	dword [ebp-4]
; [169] Count:=Max4kChannels;
		mov	dword [ebp-12],16
; [170] Left:=0;
		fldz
		fstp	dword [ebp-24]
; [171] Right:=0;
		fldz
		fstp	dword [ebp-28]
; [172] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
		mov	dword [ebp-8],0
		dec	dword [ebp-8]
SYNTHASM$127:
		inc	dword [ebp-8]
; [173] IF SynthData.RealtimeData.CurrentBPMSamples=0 THEN BEGIN
		mov	eax,dword [ebp+8]
		mov	eax,dword [eax+2099060]
		test	eax,eax
                jne     NEAR SYNTHASM$131
; [174] WHILE ASSIGNED(SynthData.RealtimeData.EventOffset[Channel]) AND (SynthData.RealtimeData.TickCounter[Channel]>=SynthData.RealtimeData.EventOffset[Channel]^) DO BEGIN
                jmp     NEAR SYNTHASM$133
SYNTHASM$132:
; [175] SynthData.RealtimeData.TickCounter[Channel]:=0;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	dword [edx+eax*4+2098800],0
; [176] Note:=SynthData.RealtimeData.NoteOffset[Channel]^;
		mov	esi,dword [edx+eax*4+2098928]
		lea	edi,[ebp-44]
		cld
		mov	ecx,1
		rep
		movsb
; [177] Volume:=SynthData.RealtimeData.VolumeOffset[Channel]^;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	esi,dword [edx+eax*4+2098992]
		lea	edi,[ebp-48]
		cld
		mov	ecx,1
		rep
		movsb
; [178] INC(SynthData.RealtimeData.EventOffset[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		inc	dword [edx+eax*4+2098864]
; [179] INC(SynthData.RealtimeData.NoteOffset[Channel]);
		inc	dword [edx+eax*4+2098928]
; [180] INC(SynthData.RealtimeData.VolumeOffset[Channel]);
		inc	dword [edx+eax*4+2098992]
; [181] IF (Note<>0) AND (Note<=$81) THEN BEGIN
		mov	esi,eax
		movzx	eax,byte [ebp-44]
		test	eax,eax
                je      NEAR SYNTHASM$142
		cmp	eax,129
                jnle    NEAR SYNTHASM$142
; [182] IF Note<$80 THEN BEGIN
		cmp	eax,128
                jnl     NEAR SYNTHASM$145
; [183] SynthData.RealtimeData.PhaseIncrement[Channel]:=F_POWER(2,(Note-49)*Div12)*SampleRateFactor;
		mov	ebx,edx
		sub	eax,49
		mov	dword [ebp-52],eax
		fild	dword [ebp-52]
                fld     tword [SYNTHASM$150]
		fmulp	st1,st0
		sub	esp,4
		fstp	dword [esp]
                push    dword [SYNTHASM$153]
		call	NEAR SYNTH_F_POWER$SINGLE$SINGLE
                fld     tword [SYNTHASM$154]
		fmulp	st1,st0
		fstp	dword [ebx+esi*4+2098032]
; [184] SynthData.RealtimeData.PhaseFactor[Channel]:=SynthData.FileData.StartPhaseFactor[Channel];
		mov	ecx,dword [ebp+8]
		mov	ebx,dword [ebp-8]
		lea	edi,[ecx+ebx*4+2098096]
		lea	esi,[ecx+ebx*4+288]
		cld
		mov	ecx,4
		rep
		movsb
; [185] SynthData.RealtimeData.Volume[Channel]:=SynthData.FileData.StartVolume[Channel];
		mov	ecx,dword [ebp+8]
		mov	ebx,dword [ebp-8]
		lea	edi,[ecx+ebx*4+2097776]
		lea	esi,[ecx+ebx*4+160]
		cld
		mov	ecx,4
		rep
		movsb
; [186] SynthData.RealtimeData.VolumeFactor[Channel]:=SynthData.FileData.StartVolumeFactor[Channel];
		mov	ecx,dword [ebp+8]
		mov	ebx,dword [ebp-8]
		lea	edi,[ecx+ebx*4+2097904]
		lea	esi,[ecx+ebx*4+224]
		cld
		mov	ecx,4
		rep
		movsb
                jmp     NEAR SYNTHASM$161
SYNTHASM$145:
; [187] END ELSE IF Note=$80 THEN BEGIN
		movzx	eax,byte [ebp-44]
		cmp	eax,128
                jne     NEAR SYNTHASM$163
; [188] SynthData.RealtimeData.PhaseIncrement[Channel]:=0;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fldz
		fstp	dword [edx+eax*4+2098032]
; [189] SynthData.RealtimeData.PhaseFactor[Channel]:=1;
		fld1
		fstp	dword [edx+eax*4+2098096]
SYNTHASM$163:
SYNTHASM$161:
; [191] IF Volume<=64 THEN BEGIN
		movzx	eax,byte [ebp-48]
		cmp	eax,64
                jnle    NEAR SYNTHASM$173
; [192] SynthData.RealtimeData.VolumeValue[Channel]:=Volume*Div64;
		mov	ecx,dword [ebp+8]
		mov	edx,dword [ebp-8]
		mov	dword [ebp-52],eax
		fild	dword [ebp-52]
                fld     tword [SYNTHASM$172]
		fmulp	st1,st0
		fstp	dword [ecx+edx*4+2097840]
SYNTHASM$169:
                jmp     NEAR SYNTHASM$173
SYNTHASM$142:
; [195] Value:=Volume*Div256;
		movzx	eax,byte [ebp-48]
		mov	dword [ebp-52],eax
		fild	dword [ebp-52]
                fld     tword [SYNTHASM$176]
		fmulp	st1,st0
		fstp	dword [ebp-40]
; [196] CASE Note OF
		mov	al,byte [ebp-44]
		cmp	al,130
                jb      NEAR SYNTHASM$178
		cmp	al,144
                ja      NEAR SYNTHASM$178
		movzx	eax,al
                jmp     [SYNTHASM$179+eax*4-520]
SYNTHASM$101:
; [211] $90:SynthData.RealtimeData.Filter[Channel].RHP:=Value;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	edi,[edx+eax+2098196]
		lea	esi,[ebp-40]
		cld
		mov	ecx,4
		rep
		movsb
                jmp     NEAR SYNTHASM$177
SYNTHASM$99:
; [210] $89:SynthData.RealtimeData.Filter[Channel].RLP:=Value;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	edi,[edx+eax+2098192]
		lea	esi,[ebp-40]
		cld
		mov	ecx,4
		rep
		movsb
                jmp     NEAR SYNTHASM$177
SYNTHASM$97:
; [209] $88:SynthData.RealtimeData.Filter[Channel].CHP:=Value;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	edi,[edx+eax+2098188]
		lea	esi,[ebp-40]
		cld
		mov	ecx,4
		rep
		movsb
                jmp     NEAR SYNTHASM$177
SYNTHASM$95:
; [206] SynthData.RealtimeData.Filter[Channel].CLP:=Value;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	edi,[edx+eax+2098184]
		lea	esi,[ebp-40]
		cld
		mov	ecx,4
		rep
		movsb
; [207] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098160]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
                jmp     NEAR SYNTHASM$177
SYNTHASM$93:
; [204] $86:SynthData.FileData.Panning[Channel]:=Volume;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		lea	edi,[edx+eax*1+352]
		lea	esi,[ebp-48]
		cld
		mov	ecx,1
		rep
		movsb
                jmp     NEAR SYNTHASM$177
SYNTHASM$90:
; [200] OscValue:=Volume*PortamentoFactor;
		movzx	eax,byte [ebp-48]
		mov	dword [ebp-52],eax
		fild	dword [ebp-52]
                fld     tword [SYNTHASM$194]
		fmulp	st1,st0
		fstp	dword [ebp-36]
; [201] IF Note=$84 THEN OscValue:=-OscValue;
		movzx	eax,byte [ebp-44]
		cmp	eax,132
                jne     NEAR SYNTHASM$196
		fld	dword [ebp-36]
		fchs
		fstp	dword [ebp-36]
SYNTHASM$196:
; [202] SynthData.RealtimeData.PhaseIncrement[Channel]:=SynthData.RealtimeData.PhaseIncrement[Channel]*(1+OscValue);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [edx+eax*4+2098032]
		fld1
		fadd	dword [ebp-36]
		fmulp	st1,st0
		fstp	dword [edx+eax*4+2098032]
                jmp     NEAR SYNTHASM$177
SYNTHASM$88:
; [198] $83:SynthData.RealtimeData.EventOffset[Channel]:=NIL;
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	dword [edx+eax*4+2098864],0
                jmp     NEAR SYNTHASM$177
SYNTHASM$86:
; [197] $82:SynthData.RealtimeData.BPMSamples:=(SampleRate*5*128) DIV (Volume SHL 8);
		movzx	ecx,byte [ebp-48]
		shl	ecx,8
		mov	eax,28224000
		mov	edx,0
		div	ecx
		mov	edx,dword [ebp+8]
		mov	dword [edx+2099056],eax
SYNTHASM$178:
SYNTHASM$177:
SYNTHASM$173:
SYNTHASM$133:
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		cmp	dword [edx+eax*4+2098864],0
                je      NEAR SYNTHASM$134
		mov	ecx,dword [edx+eax*4+2098864]
		movzx	ecx,byte [ecx]
		cmp	ecx,dword [edx+eax*4+2098800]
                jle     NEAR SYNTHASM$132
SYNTHASM$134:
; [215] IF NOT ASSIGNED(SynthData.RealtimeData.EventOffset[Channel]) THEN DEC(Count);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		cmp	dword [edx+eax*4+2098864],0
                jne     NEAR SYNTHASM$207
SYNTHASM$206:
		dec	dword [ebp-12]
SYNTHASM$207:
; [216] INC(SynthData.RealtimeData.TickCounter[Channel]);
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		inc	dword [edx+eax*4+2098800]
SYNTHASM$131:
; [218] Phase:=FRAC(SynthData.RealtimeData.Phase[Channel]+SynthData.RealtimeData.LinkValues[Channel]);
		mov	edx,dword [ebp+8]
		mov	ebx,dword [ebp-8]
		fld	dword [edx+ebx*4+2097712]
		fadd	dword [edx+ebx*4+2097968]
		sub	esp,4
		fstp	dword [esp]
		call	NEAR SYNTH_FRAC$SINGLE
		fstp	dword [ebp-20]
; [219] WaveForm:=SynthData.FileData.WaveForm[Channel];
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		movzx	eax,byte [edx+eax*1]
		mov	dword [ebp-16],eax
; [220] CASE WaveForm OF
		test	eax,eax
                jl      NEAR SYNTHASM$215
		cmp	eax,5
                jg      NEAR SYNTHASM$215
                jmp     [SYNTHASM$216+eax*4]
SYNTHASM$112:
; [228] 5:OscValue:=WhiteNoiseRandom; // White Noise
		call	NEAR SYNTH_WHITENOISERANDOM
		fstp	dword [ebp-36]
                jmp     NEAR SYNTHASM$214
SYNTHASM$109:
; [227] 3,4:OscValue:=((Phase-0.5)*2)*INTEGER(1-((WaveForm-3)*2)); // Sawtooth Up/Down
		mov	eax,dword [ebp-16]
		sub	eax,3
		shl	eax,1
		mov	edx,1
		sub	edx,eax
		mov	dword [ebp-52],edx
		fild	dword [ebp-52]
		fld	dword [ebp-20]
                fld     tword [SYNTHASM$221]
		fsubp	st1,st0
                fld     tword [SYNTHASM$222]
		fmulp	st1,st0
		fmulp	st1,st0
		fstp	dword [ebp-36]
                jmp     NEAR SYNTHASM$214
SYNTHASM$107:
; [224] Phase:=Phase-0.5;
		fld	dword [ebp-20]
                fld     tword [SYNTHASM$221]
		fsubp	st1,st0
		fstp	dword [ebp-20]
; [225] OscValue:=1-((PhaseCasted SHR 31) SHL 1);
		mov	eax,dword [ebp-20]
		shr	eax,31
		shl	eax,1
		mov	edx,1
		sub	edx,eax
		mov	dword [ebp-52],edx
		mov	dword [ebp-60],edx
		mov	dword [ebp-56],0
		fild	qword [ebp-60]
		fstp	dword [ebp-36]
                jmp     NEAR SYNTHASM$214
SYNTHASM$105:
; [222] 1:OscValue:=ABS((Phase-0.5)*4)-1; // Triangle
		fld	dword [ebp-20]
                fld     tword [SYNTHASM$221]
		fsubp	st1,st0
                fld     tword [SYNTHASM$229]
		fmulp	st1,st0
		fabs
		fld1
		fsubp	st1,st0
		fstp	dword [ebp-36]
                jmp     NEAR SYNTHASM$214
SYNTHASM$103:
; [221] 0:OscValue:=SIN(Phase*2*PI); // Sinus
		fld	dword [ebp-20]
                fld     tword [SYNTHASM$222]
		fmulp	st1,st0
		fldpi
		fmulp	st1,st0
		fsin
		fstp	dword [ebp-36]
                jmp     NEAR SYNTHASM$214
SYNTHASM$215:
; [229] ELSE OscValue:=0; // Nothing ;-)
		fldz
		fstp	dword [ebp-36]
SYNTHASM$214:
; [231] OscValue:=OscValue*SynthData.RealtimeData.Volume[Channel]*SynthData.RealtimeData.VolumeValue[Channel];
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fld	dword [ebp-36]
		fmul	dword [edx+eax*4+2097776]
		fmul	dword [edx+eax*4+2097840]
		fstp	dword [ebp-36]
; [232] WITH SynthData.RealtimeData.Filter[Channel] DO BEGIN
		imul	eax,40
		lea	eax,[edx+eax+2098160]
; [233] FD1:=FD1+CLP*(OscValue-FD1+FBLP*(FD1-FD2));
		fld	dword [eax+4]
		fsubr	dword [eax]
		fmul	dword [eax+16]
		fld	dword [ebp-36]
		fsub	dword [eax]
		faddp	st1,st0
		fmul	dword [eax+24]
		fadd	dword [eax]
		fstp	dword [eax]
; [234] FD2:=FD2+CLP*(FD1-FD2);
		fld	dword [eax+4]
		fsubr	dword [eax]
		fmul	dword [eax+24]
		fadd	dword [eax+4]
		fstp	dword [eax+4]
; [235] FD3:=FD3+CHP*(FD2-FD3+FBHP*(FD3-FD4));
		fld	dword [eax+8]
		fsubr	dword [eax+4]
		fld	dword [eax+12]
		fsubr	dword [eax+8]
		fmul	dword [eax+20]
		faddp	st1,st0
		fmul	dword [eax+28]
		fadd	dword [eax+8]
		fstp	dword [eax+8]
; [236] FD4:=FD4+CHP*(FD3-FD4);
		fld	dword [eax+12]
		fsubr	dword [eax+8]
		fmul	dword [eax+28]
		fadd	dword [eax+12]
		fst	dword [eax+12]
; [237] OscValue:=FD2-FD4;
		fsubr	dword [eax+4]
		fstp	dword [ebp-36]
; [239] IF (SynthData.FileData.Link[Channel] AND $7F)<Max4kChannels THEN BEGIN
		mov	eax,dword [ebp-8]
		mov	ecx,dword [edx+eax*1+16]
		and	ecx,127
		cmp	ecx,16
                jnl     NEAR SYNTHASM$249
; [240] SynthData.RealtimeData.LinkValues[SynthData.FileData.Link[Channel] AND $7F]:=OscValue*SynthData.FileData.LinkFactor[Channel];
		fld	dword [ebp-36]
		fmul	dword [edx+eax*4+32]
		fstp	dword [edx+ecx*4+2097712]
SYNTHASM$249:
; [242] IF (SynthData.FileData.Link[Channel] AND $80)<>0 THEN BEGIN
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		mov	eax,dword [edx+eax*1+16]
		and	eax,128
                je      NEAR SYNTHASM$253
; [243] Value:=OscValue*SynthData.FileData.OutFactor[Channel];
		mov	eax,dword [ebp-8]
		fld	dword [ebp-36]
		fmul	dword [edx+eax*4+96]
		fstp	dword [ebp-40]
; [244] PanningValue:=SynthData.FileData.Panning[Channel]*Div255;
		movzx	eax,byte [edx+eax*1+352]
		mov	dword [ebp-52],eax
		fild	dword [ebp-52]
                fld     tword [SYNTHASM$258]
		fmulp	st1,st0
		fst	dword [ebp-32]
; [245] Left:=Left+(Value*PanningValue);
		fmul	dword [ebp-40]
		fadd	dword [ebp-24]
		fstp	dword [ebp-24]
; [246] Right:=Right+(Value*(1-PanningValue));
		fld	dword [ebp-28]
		fld	dword [ebp-40]
		fld1
		fsub	dword [ebp-32]
		fmulp	st1,st0
		faddp	st1,st0
		fstp	dword [ebp-28]
SYNTHASM$253:
; [248] SynthData.RealtimeData.Phase[Channel]:=FRAC(SynthData.RealtimeData.Phase[Channel]+SynthData.RealtimeData.PhaseIncrement[Channel]);
		mov	ebx,dword [ebp+8]
		mov	edx,dword [ebp-8]
		fld	dword [ebx+edx*4+2098032]
		fadd	dword [ebx+edx*4+2097968]
		sub	esp,4
		fstp	dword [esp]
		call	NEAR SYNTH_FRAC$SINGLE
		mov	edx,dword [ebp+8]
		mov	eax,dword [ebp-8]
		fstp	dword [edx+eax*4+2097968]
; [249] SynthData.RealtimeData.PhaseIncrement[Channel]:=SynthData.RealtimeData.PhaseIncrement[Channel]*SynthData.RealtimeData.PhaseFactor[Channel];
		fld	dword [edx+eax*4+2098096]
		fmul	dword [edx+eax*4+2098032]
		fstp	dword [edx+eax*4+2098032]
; [250] SynthData.RealtimeData.Volume[Channel]:=SynthData.RealtimeData.Volume[Channel]*SynthData.RealtimeData.VolumeFactor[Channel];
		fld	dword [edx+eax*4+2097904]
		fmul	dword [edx+eax*4+2097776]
		fstp	dword [edx+eax*4+2097776]
		cmp	eax,15
                jl      NEAR SYNTHASM$127
; [252] IF SynthData.RealtimeData.CurrentBPMSamples=0 THEN BEGIN
		mov	eax,dword [edx+2099060]
		test	eax,eax
                jne     NEAR SYNTHASM$272
; [253] IF Count=0 THEN SynthReinit(SynthData);
		mov	eax,dword [ebp-12]
		test	eax,eax
                jne     NEAR SYNTHASM$274
		mov	eax,edx
		push	eax
		call	NEAR SYNTH_SYNTHREINIT$T4KSYNTHDATA
SYNTHASM$274:
; [254] SynthData.RealtimeData.CurrentBPMSamples:=SynthData.RealtimeData.BPMSamples;
		mov	edx,dword [ebp+8]
		lea	edi,[edx+2099060]
		lea	esi,[edx+2099056]
		cld
		mov	ecx,4
		rep
		movsb
SYNTHASM$272:
; [256] DEC(SynthData.RealtimeData.CurrentBPMSamples);
		mov	eax,dword [ebp+8]
		dec	dword [eax+2099060]
; [257] Buffer^:=Left*Div8;
		mov	eax,dword [ebp+12]
		fld	dword [ebp-24]
                fld     tword [SYNTHASM$281]
		fmulp	st1,st0
		fstp	dword [eax]
; [258] INC(Buffer);
		add	dword [ebp+12],4
; [259] Buffer^:=Right*Div8;
		mov	eax,dword [ebp+12]
		fld	dword [ebp-28]
                fld     tword [SYNTHASM$281]
		fmulp	st1,st0
		fstp	dword [eax]
; [260] INC(Buffer);
		add	dword [ebp+12],4
		cmp	dword [ebp-4],4096
                jl      NEAR SYNTHASM$116
; [262] END;
		mov	ebx,dword [ebp-72]
		mov	esi,dword [ebp-68]
		mov	edi,dword [ebp-64]
		leave
		ret	8

; [267] BEGIN
SYNTH_SYNTHINIT$POINTER$LONGINT:
SynthInit:
; Temps allocated between ebp-4 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,4
; Para TrackData located at ebp+8
; Para TrackSize located at ebp+12
; Local Counter located at ebp-4
; [269] FLDCW cwChop
		fldcw	word [TC_SYNTH_SYNTHINIT$_CWCHOP]
; [272] FILLCHAR(SynthData,SIZEOF(T4kSynthData),#0);
                xor     eax,eax
                mov     ecx,2099064
                mov     edi,dword U_SYNTH_SYNTHDATA
                rep     stosb
; [273] MOVE(TrackData^,SynthData,TrackSize);
		mov	ecx,dword [ebp+12]
                mov     edi,dword U_SYNTH_SYNTHDATA
                mov     esi,dword [ebp+8]
                rep     movsb
; [274] SynthInitData(SynthData);
		push	dword U_SYNTH_SYNTHDATA
		call	NEAR SYNTH_SYNTHINITDATA$T4KSYNTHDATA
; [276] WhiteNoiseSeed:=$12345678;
		mov	dword [U_SYNTH_WHITENOISESEED],305419896
; [278] waveOutOpen(@WaveOutHandle,WAVE_MAPPER,@WaveFormat,0,0,0);
                INVOKE  waveOutOpen,dword U_SYNTH_WAVEOUTHANDLE,dword -1,dword TC_SYNTH_WAVEFORMAT,byte 0,byte 0,byte 0 
; [280] FOR Counter:=0 TO 3 DO BEGIN
		mov	dword [ebp-4],0
		dec	dword [ebp-4]
SYNTHASM$316:
		inc	dword [ebp-4]
; [281] WaveHandler[Counter].dwFlags:=WHDR_DONE;
		mov	eax,dword [ebp-4]
		shl	eax,5
                mov     dword [eax+U_SYNTH_WAVEHANDLER+16],1
; [282] WaveHandler[Counter].lpData:=@Buffers[Counter];
		mov	eax,dword [ebp-4]
		imul	eax,32776
		lea	edx,[U_SYNTH_BUFFERS+eax]
		mov	eax,dword [ebp-4]
		shl	eax,5
                mov     dword [eax+U_SYNTH_WAVEHANDLER],edx
; [283] WaveHandler[Counter].dwBufferLength:=BufferSize*8;
                mov     dword [eax+U_SYNTH_WAVEHANDLER+4],32768
		cmp	dword [ebp-4],3
                jl      NEAR SYNTHASM$316
; [286] BufferCounter:=0;
		mov	dword [U_SYNTH_BUFFERCOUNTER],0
; [287] END;
		leave
		ret	8

; [290] BEGIN
SYNTH_SYNTHPOLL$POINTER$LONGINT:
SynthPoll:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para TrackData located at ebp+8
; Para TrackSize located at ebp+12
; [291] IF (WaveHandler[BufferCounter].dwFlags AND WHDR_DONE)<>0 THEN BEGIN
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
                mov     eax,dword [eax+U_SYNTH_WAVEHANDLER+16]
		and	eax,1
                je      NEAR SYNTHASM$330
; [292] IF waveOutUnprepareHeader(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR))<>WAVERR_STILLPLAYING THEN BEGIN
		push	dword 32
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
                lea     eax,[eax+U_SYNTH_WAVEHANDLER]
		push	eax
		push	dword [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutUnprepareHeader
		cmp	eax,33
                je      NEAR SYNTHASM$332
; [293] WaveHandler[BufferCounter].dwFlags:=WaveHandler[BufferCounter].dwFlags AND NOT WHDR_DONE;
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
                and     dword [eax+U_SYNTH_WAVEHANDLER+16],-2
; [294] SynthFillBuffer(SynthData,@WaveHandler[BufferCounter].lpData^);
                mov     edx,dword [eax+U_SYNTH_WAVEHANDLER]
		push	edx
		push	dword U_SYNTH_SYNTHDATA
		call	NEAR SYNTH_SYNTHFILLBUFFER$T4KSYNTHDATA$PSINGLE
; [295] waveOutPrepareHeader(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR));
		push	dword 32
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
                lea     eax,[eax+U_SYNTH_WAVEHANDLER]
		push	eax
		push	dword [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutPrepareHeader
; [296] waveOutWrite(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR));
		push	dword 32
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
                push    dword [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutWrite
; [297] BufferCounter:=(BufferCounter+1) MOD 4;
		mov	eax,dword [U_SYNTH_BUFFERCOUNTER]
		inc	eax
		and	eax,3
		mov	dword [U_SYNTH_BUFFERCOUNTER],eax
SYNTHASM$332:
SYNTHASM$330:
; [300] END;
		leave
		ret	8

; [304] BEGIN
SYNTH_SYNTHDONE$POINTER$LONGINT:
.IF(Synthclean){
.SMARTLINK SynthDone {
; Temps allocated between ebp-4 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,4
; Para TrackData located at ebp+8
; Para TrackSize located at ebp+12
; Local Counter located at ebp-4
; [305] FOR Counter:=0 TO 3 DO BEGIN
		mov	dword [ebp-4],0
		dec	dword [ebp-4]
SYNTHASM$363:
		inc	dword [ebp-4]
SYNTHASM$366:
SYNTHASM$367:
; [306] WHILE waveOutUnprepareHeader(WaveOutHandle,@WaveHandler[Counter],SIZEOF(TWAVEHDR))=WAVERR_STILLPLAYING DO BEGIN
		push	dword 32
		mov	eax,dword [ebp-4]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
		push	dword [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutUnprepareHeader
		cmp	eax,33
                je      NEAR SYNTHASM$366
SYNTHASM$368:
		cmp	dword [ebp-4],3
                jl      NEAR SYNTHASM$363
                mov eax,dword ptr [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutReset,eax
                mov eax,dword ptr [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutClose,eax
; [311] END;
		leave
		ret	8
}
}

; [79] CONST WaveFormat:TWaveFormatEx=(wFormatTag:3;nChannels:2;nSamplesPerSec:SampleRate;
TC_SYNTH_WAVEFORMAT:
        DW      3,2
	DD	44100,352800
	DW	8,32,0
SYNTHASM$179:
                DD      SYNTHASM$86
                DD      SYNTHASM$88
                DD      SYNTHASM$90
                DD      SYNTHASM$90
                DD      SYNTHASM$93
                DD      SYNTHASM$95
                DD      SYNTHASM$97
                DD      SYNTHASM$99
                DD      SYNTHASM$178
                DD      SYNTHASM$178
                DD      SYNTHASM$178
                DD      SYNTHASM$178
                DD      SYNTHASM$178
                DD      SYNTHASM$178
                DD      SYNTHASM$101
SYNTHASM$216:
                DD      SYNTHASM$103
                DD      SYNTHASM$105
                DD      SYNTHASM$107
                DD      SYNTHASM$109
                DD      SYNTHASM$109
                DD      SYNTHASM$112

; [265] CONST cwChop:WORD=$F7B;
TC_SYNTH_SYNTHINIT$_CWCHOP:      DW      3963
; [314] 

SYNTHASM$40:
                DEF       3.0000000000000000e0000

SYNTHASM$81:
                DSF       9.960937500e-01

SYNTHASM$150:
                DEF       8.3333333333333333e-0002

SYNTHASM$153:
                DSF       2.000000000e00

SYNTHASM$154:
                DEF       9.9773242630385488e-0003

SYNTHASM$172:
                DEF       1.5625000000000000e-0002

SYNTHASM$176:
                DEF       3.9062500000000000e-0003

SYNTHASM$194:
                DEF       1.5224188633786848e-0007

SYNTHASM$221:
                DEF       5.0000000000000000e-0001

SYNTHASM$222:
                DEF       2.0000000000000000e0000

SYNTHASM$229:
                DEF       4.0000000000000000e0000

SYNTHASM$258:
                DEF       3.9215686274509804e-0003

SYNTHASM$281:
                DEF       1.2500000000000000e-0001


