
Synthclean=0

.LIBRARY "winmm.dll"
IMPORT waveOutWrite "waveOutWrite"
IMPORT waveOutUnprepareHeader "waveOutUnprepareHeader"
IMPORT waveOutPrepareHeader "waveOutPrepareHeader"
IMPORT waveOutOpen "waveOutOpen"

.IF(Synthclean){
 IMPORT waveOutReset "waveOutReset"
 IMPORT waveOutClose "waveOutClose"
}

; [synth.pas]
; [138] END;
SYNTH_F_POWER$SINGLE$SINGLE:
F_POWER:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para Number located at ebp+8
; Para Exponent located at ebp+12
; [128] FLD Exponent
                fld     dword ptr [ebp+12]
; [129] FLD Number
                fld     dword ptr [ebp+8]
; [130] FYL2X
		fyl2x
; [131] FLD1
		fld1
; [132] FLD ST(1)
		fld	st1
; [133] FPREM
		fprem
; [134] F2XM1
		f2xm1
; [135] FADDP ST(1),ST
		faddp	st1,st0
; [136] FSCALE
		fscale
; [137] FSTP ST(1)
		fstp	st1
		leave
		ret	8

SYNTH_WHITENOISERANDOM:
WhiteNoiseRandom:
; Temps allocated between ebp-8 and ebp-8
		push	ebp
		mov	ebp,esp
		sub	esp,8
; Local $result located at ebp-4
; Local WhiteNoiseValue located at ebp-8
; [143] WhiteNoiseSeed:=(WhiteNoiseSeed*$524281)+$3133731;
                mov     edx,dword ptr [U_SYNTH_WHITENOISESEED]
		mov	eax,5390977
		mul	edx
		add	eax,51590961
                mov     dword ptr [U_SYNTH_WHITENOISESEED],eax
; [144] WhiteNoiseValue:=(WhiteNoiseSeed AND $7FFFFF) OR $40000000;
		and	eax,8388607
		or	eax,1073741824
                mov     dword ptr [ebp-8],eax
; [145] RESULT:=SINGLE(POINTER(@WhiteNoiseValue)^)-3;
		lea	eax,[ebp-8]
                fld     dword ptr [eax]
                fld     tword [SYNTHASM$54]
		fsubp	st1,st0
                fstp    dword ptr [ebp-4]
; [146] END;
                fld     dword ptr [ebp-4]
		leave
		ret

SYNTH_FRAC$SINGLE:
FRAC:
; Temps allocated between ebp-16 and ebp-8
		push	ebp
		mov	ebp,esp
		sub	esp,16
                mov     dword ptr [ebp-16],esi
                mov     dword ptr [ebp-12],edi
; Para X located at ebp+8
; Local $result located at ebp-4
; Local Y located at ebp-8
; [151] Y:=X;
                mov ecx,dword ptr [ebp+8]
                mov dword ptr [ebp-8],ecx
; [153] FLD DWORD PTR Y
                fld     dword ptr [ebp-8]
; [154] FRNDINT
		frndint
; [155] FSTP DWORD PTR Y
                fstp    dword ptr [ebp-8]
; [157] RESULT:=X-Y;
                fld     dword ptr [ebp-8]
                fsubr   dword ptr [ebp+8]
                fstp    dword ptr [ebp-4]
; [158] END;
                fld     dword ptr [ebp-4]
                mov     esi,dword ptr [ebp-16]
                mov     edi,dword ptr [ebp-12]
		leave
		ret	4

SYNTH_SYNTHREINIT$T4KSYNTHDATA:
SynthReinit:
; Temps allocated between ebp-16 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,16
                mov     dword ptr [ebp-16],ebx
                mov     dword ptr [ebp-12],esi
                mov     dword ptr [ebp-8],edi
; Para SynthData located at ebp+8
; Local Channel located at ebp-4
; [163] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
                mov     dword ptr [ebp-4],0
                dec     dword ptr [ebp-4]
SYNTHASM$65:
                inc     dword ptr [ebp-4]
; [164] SynthData.RealtimeData.EventOffset[Channel]:=SynthData.RealtimeData.RestartEventOffset[Channel];
                mov     ebx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-4]
		mov     esi,dword ptr [ebx+ecx*4+2099608]
	        mov     dword ptr [ebx+ecx*4+2099416],esi
; [165] SynthData.RealtimeData.NoteOffset[Channel]:=SynthData.RealtimeData.RestartNoteOffset[Channel];
                mov     ebx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-4]
		mov	esi,dword ptr [ebx+ecx*4+2099672]
		mov	dword ptr [ebx+ecx*4+2099480],esi
; [166] SynthData.RealtimeData.VolumeOffset[Channel]:=SynthData.RealtimeData.RestartVolumeOffset[Channel];
                mov     ebx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-4]
		mov	esi,dword [ebx+ecx*4+2099736]
		mov	dword [ebx+ecx*4+2099544],esi
; [167] SynthData.RealtimeData.TickCounter[Channel]:=0;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-4]
                mov     dword ptr [edx+eax*4+2099352],0
		cmp	eax,15
                jl      NEAR SYNTHASM$65
; [169] SynthData.RealtimeData.ShouldExit:=TRUE;
		mov	byte [edx+2099808],1
; [170] END;
                mov     ebx,dword ptr [ebp-16]
                mov     esi,dword ptr [ebp-12]
                mov     edi,dword ptr [ebp-8]
		leave
		ret	4

SYNTH_SYNTHRECALCFILTER$T4KFILTER:
SynthRecalcFilter:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para Filter located at ebp+8
; [174] WITH Filter DO BEGIN
                mov     eax,dword ptr [ebp+8]
; [175] FBLP:=RLP+RLP/(1-CLP);
                fld     dword ptr [eax+32]
                fld     dword ptr [eax+32]
                fld     dword ptr [eax+24]
		fld1
		fsubrp	st1,st0
		fdivp	st1,st0
		faddp	st1,st0
                fstp    dword ptr [eax+16]
; [176] FBHP:=RHP+RHP/(1-CLP);
                fld     dword ptr [eax+36]
                fld     dword ptr [eax+36]
                fld     dword ptr [eax+24]
		fld1
		fsubrp	st1,st0
		fdivp	st1,st0
		faddp	st1,st0
                fstp    dword ptr [eax+20]
; [178] END;
		leave
		ret	4

SYNTH_SYNTHINITDATA$T4KSYNTHDATA:
SynthInitData:
; Temps allocated between ebp-12 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,12
                mov     dword ptr [ebp-12],esi
                mov     dword ptr [ebp-8],edi
; Para SynthData located at ebp+8
; Local Channel located at ebp-4
; [183] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
                mov     dword ptr [ebp-4],0
                dec     dword ptr [ebp-4]
SYNTHASM$88:
                inc     dword ptr [ebp-4]
; [184] IF SynthData.FileData.EventOffset[Channel]>0 THEN BEGIN
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-4]
                mov     eax,dword ptr [edx+eax*4+368]
		test	eax,eax
                jng     NEAR SYNTHASM$92
; [185] SynthData.RealtimeData.RestartEventOffset[Channel]:=POINTER(LONGWORD(@SynthData)+LONGWORD(SynthData.FileData.EventOffset[Channel]));
                mov     ecx,dword ptr [ebp-4]
		mov	eax,edx
                add     eax,dword ptr [edx+ecx*4+368]
                mov     dword ptr [edx+ecx*4+2099608],eax
; [186] SynthData.RealtimeData.RestartNoteOffset[Channel]:=POINTER(LONGWORD(@SynthData)+LONGWORD(SynthData.FileData.NoteOffset[Channel]));
		mov	eax,edx
                add     eax,dword ptr [edx+ecx*4+432]
                mov     dword ptr [edx+ecx*4+2099672],eax
; [187] SynthData.RealtimeData.RestartVolumeOffset[Channel]:=POINTER(LONGWORD(@SynthData)+LONGWORD(SynthData.FileData.VolumeOffset[Channel]));
		mov	eax,edx
                add     eax,dword ptr [edx+ecx*4+496]
                mov     dword ptr [edx+ecx*4+2099736],eax
SYNTHASM$92:
; [189] SynthData.RealtimeData.Filter[Channel].CLP:=CutOffLowPassStartValue;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-4]
		imul	eax,40
                mov     esi,dword SYNTHASM$101
                mov     edi,dword [esi]
		mov	dword [edx+eax+2098728],edi
; [190] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-4]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
                cmp     dword ptr [ebp-4],15
                jl      NEAR SYNTHASM$88
; [192] SynthReinit(SynthData);
                mov     eax,dword ptr [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHREINIT$T4KSYNTHDATA
; [193] SynthData.RealtimeData.ShouldExit:=FALSE;
                mov     eax,dword ptr [ebp+8]
		mov	byte [eax+2099808],0
; [194] END;
                mov     esi,dword ptr [ebp-12]
                mov     edi,dword ptr [ebp-8]
		leave
		ret	4

SYNTH_SYNTHCALCNOTE$T4KSYNTHDATA$LONGINT$LONGINT:
SynthCalcNote:
; Temps allocated between ebp-12 and ebp+0
		push	ebp
		mov	ebp,esp
		sub	esp,12
                mov     dword ptr [ebp-12],ebx
                mov     dword ptr [ebp-8],esi
; Para SynthData located at ebp+8
; Para Channel located at ebp+12
; Para Note located at ebp+16
; [198] SynthData.RealtimeData.PhaseIncrement[Channel]:=F_POWER(2,(Note-45)*Div12)*SampleRateFactor;
                mov     esi,dword ptr [ebp+8]
                mov     ebx,dword ptr [ebp+12]
                mov     eax,dword ptr [ebp+16]
		sub	eax,45
                mov     dword ptr [ebp-4],eax
                fild    dword ptr [ebp-4]
                fld     tword [SYNTHASM$114]
		fmulp	st1,st0
		sub	esp,4
                fstp    dword ptr [esp]
                push    dword ptr [SYNTHASM$117]
		call	NEAR SYNTH_F_POWER$SINGLE$SINGLE
                fld     tword [SYNTHASM$118]
		fmulp	st1,st0
                fstp    dword ptr [esi+ebx*4+2098576]
; [199] END;
                mov     ebx,dword ptr [ebp-12]
                mov     esi,dword ptr [ebp-8]
		leave
		ret	12

SYNTH_SYNTHFILLBUFFER$T4KSYNTHDATA$PSINGLE$LONGINT$LONGINT:
SynthFillBuffer:
; Temps allocated between ebp-76 and ebp-48
		push	ebp
		mov	ebp,esp
		sub	esp,76
                mov     dword ptr [ebp-76],ebx
                mov     dword ptr [ebp-72],esi
                mov     dword ptr [ebp-68],edi
; Para SynthData located at ebp+8
; Para Buffer located at ebp+12
; Para StartPosition located at ebp+16
; Para BufferSize located at ebp+20
; Local Position located at ebp-4
; Local Channel located at ebp-8
; Local Count located at ebp-12
; Local WaveForm located at ebp-16
; Local Phase located at ebp-20
; Local Left located at ebp-24
; Local Right located at ebp-28
; Local PanningValue located at ebp-32
; Local OscValue located at ebp-36
; Local Value located at ebp-40
; Local Note located at ebp-44
; Local Volume located at ebp-48
; [207] FOR Position:=0 TO BufferSize-1 DO BEGIN
                mov     eax,dword ptr [ebp+20]
		dec	eax
                mov     dword ptr [ebp-52],eax
		mov	eax,0
                mov     dword ptr [ebp-4],eax
                cmp     eax,dword ptr [ebp-52]
                jg      NEAR SYNTHASM$166
                dec     dword ptr [ebp-4]
SYNTHASM$167:
                inc     dword ptr [ebp-4]
; [208] Count:=Max4kChannels;
                mov     dword ptr [ebp-12],16
; [209] Left:=0;
		fldz
                fstp    dword ptr [ebp-24]
; [210] Right:=0;
		fldz
                fstp    dword ptr [ebp-28]
; [211] FILLCHAR(SynthData.RealtimeData.LinkFirst,16,#1);
		mov	cl,1
		mov	edx,16
                mov     eax,dword ptr [ebp+8]
		add	eax,2097984
                push    eax
                push    ecx 
                push    edi
                mov     edi,eax
                xor     eax,eax
                mov     ecx,edx
                rep     stosb
                pop     edi
                pop     ecx
                pop     eax
; [212] FOR Channel:=0 TO Max4kChannels-1 DO BEGIN
                mov     dword ptr [ebp-8],0
                dec     dword ptr [ebp-8]
SYNTHASM$184:
                inc     dword ptr [ebp-8]
; [213] IF SynthData.RealtimeData.CurrentBPMSamples=0 THEN BEGIN
                mov     eax,dword ptr [ebp+8]
                mov     eax,dword ptr [eax+2099804]
		test	eax,eax
                jne     NEAR SYNTHASM$188
; [214] WHILE ASSIGNED(SynthData.RealtimeData.EventOffset[Channel]) AND (SynthData.RealtimeData.TickCounter[Channel]>=SynthData.RealtimeData.EventOffset[Channel]^) DO BEGIN
                jmp     NEAR SYNTHASM$190
SYNTHASM$189:
; [215] SynthData.RealtimeData.TickCounter[Channel]:=0;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     dword ptr [edx+eax*4+2099352],0
; [216] Note:=SynthData.RealtimeData.NoteOffset[Channel]^;
                mov     esi,dword ptr [edx+eax*4+2099480]
                mov     edi,dword ptr [esi]
	        mov	dword [ebp-44],edi
; [217] Volume:=SynthData.RealtimeData.VolumeOffset[Channel]^;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     esi,dword ptr [edx+eax*4+2099544]
                mov     edi,dword ptr [esi]
		mov     dword [ebp-48],edi
; [218] INC(SynthData.RealtimeData.EventOffset[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                inc     dword ptr [edx+eax*4+2099416]
; [219] INC(SynthData.RealtimeData.NoteOffset[Channel]);
                inc     dword ptr [edx+eax*4+2099480]
; [220] INC(SynthData.RealtimeData.VolumeOffset[Channel]);
                inc     dword ptr [edx+eax*4+2099544]
; [221] IF (Note<>0) AND (Note<=$81) THEN BEGIN
		mov	ecx,eax
		movzx	eax,byte [ebp-44]
		test	eax,eax
                je      NEAR SYNTHASM$199
		cmp	eax,129
                jnle    NEAR SYNTHASM$199
; [222] IF Note<$80 THEN BEGIN
		cmp	eax,128
                jnl     NEAR SYNTHASM$202
; [223] SynthData.RealtimeData.LastLeft:=SynthData.RealtimeData.LastLeft+SynthData.RealtimeData.ChannelLastLeft[Channel];
                fld     dword ptr [edx+2099344]
                fadd    dword ptr [edx+ecx*4+2098256]
                fstp    dword ptr [edx+2099344]
; [224] SynthData.RealtimeData.LastRight:=SynthData.RealtimeData.LastRight+SynthData.RealtimeData.ChannelLastRight[Channel];
                fld     dword ptr [edx+2099348]
                fadd    dword ptr [edx+ecx*4+2098320]
                fstp    dword ptr [edx+2099348]
; [225] SynthData.RealtimeData.ChannelLastLeft[Channel]:=0;
		fldz
                fstp    dword ptr [edx+ecx*4+2098256]
; [226] SynthData.RealtimeData.ChannelLastRight[Channel]:=0;
		fldz
                fstp    dword ptr [edx+ecx*4+2098320]
; [227] SynthCalcNote(SynthData,Channel,Note);
		push	eax
		push	ecx
		mov	eax,edx
		push	eax
		call	NEAR SYNTH_SYNTHCALCNOTE$T4KSYNTHDATA$LONGINT$LONGINT
; [228] SynthData.RealtimeData.PhaseFactor[Channel]:=SynthData.FileData.StartPhaseFactor[Channel];
                mov     ecx,dword ptr [ebp+8]
                mov     ebx,dword ptr [ebp-8]
		mov	esi,dword ptr [ecx+ebx*4+288]
		mov     dword ptr [ecx+ebx*4+2098640],esi
; [229] SynthData.RealtimeData.Volume[Channel]:=SynthData.FileData.StartVolume[Channel];
                mov     ecx,dword ptr [ebp+8]
                mov     ebx,dword ptr [ebp-8]
		mov	esi,dword ptr [ecx+ebx*4+160]
		mov dword [ecx+ebx*4+2098064],esi
; [230] SynthData.RealtimeData.VolumeFactor[Channel]:=SynthData.FileData.StartVolumeFactor[Channel];
                mov     ebx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-8]
		mov     esi,dword [ebx+ecx*4+224]
		mov     dword [ebx+ecx*4+2098192],esi
; [231] SynthData.RealtimeData.ADSRMode[Channel]:=1;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     dword ptr [edx+eax*4+2098384],1
; [232] SynthData.RealtimeData.ADSRValue[Channel]:=0;
		fldz
                fstp    dword ptr [edx+eax*4+2098448]
                jmp     NEAR SYNTHASM$227
SYNTHASM$202:
; [233] END ELSE IF Note=$80 THEN BEGIN
		movzx	eax,byte [ebp-44]
		cmp	eax,128
                jne     NEAR SYNTHASM$229
; [234] SynthData.RealtimeData.ADSRMode[Channel]:=4;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     dword ptr [edx+eax*4+2098384],4
SYNTHASM$229:
SYNTHASM$227:
; [236] IF Volume<=64 THEN BEGIN
		movzx	eax,byte [ebp-48]
		cmp	eax,64
                jnle    NEAR SYNTHASM$237
; [237] SynthData.RealtimeData.VolumeValue[Channel]:=Volume*Div64;
                mov     ecx,dword ptr [ebp+8]
                mov     edx,dword ptr [ebp-8]
                mov     dword ptr [ebp-56],eax
                fild    dword ptr [ebp-56]
                fld     tword [SYNTHASM$236]
		fmulp	st1,st0
                fstp    dword ptr [ecx+edx*4+2098128]
SYNTHASM$233:
                jmp     NEAR SYNTHASM$237
SYNTHASM$199:
; [240] Value:=Volume*Div256;
		movzx	eax,byte [ebp-48]
                mov     dword ptr [ebp-56],eax
                fild    dword ptr [ebp-56]
                fld     tword [SYNTHASM$240]
		fmulp	st1,st0
                fstp    dword ptr [ebp-40]
; [241] CASE Note OF
		mov	al,byte [ebp-44]
		cmp	al,130
                jb      NEAR SYNTHASM$242
		cmp	al,147
                ja      NEAR SYNTHASM$242
		movzx	eax,al
                jmp     [SYNTHASM$243+eax*4-520]
SYNTHASM$142:
; [269] SynthData.RealtimeData.RestartEventOffset[Channel]:=SynthData.RealtimeData.EventOffset[Channel];
                mov     ecx,dword ptr [ebp+8]
                mov     ebx,dword ptr [ebp-8]
		mov	esi,dword [ecx+ebx*4+2099416]
		mov	dword [ecx+ebx*4+2099608],esi
; [270] SynthData.RealtimeData.RestartNoteOffset[Channel]:=SynthData.RealtimeData.NoteOffset[Channel];
                mov     ebx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-8]
		mov esi,dword [ebx+ecx*4+2099480]
	        mov dword [ebx+ecx*4+2099672],esi
; [271] SynthData.RealtimeData.RestartVolumeOffset[Channel]:=SynthData.RealtimeData.VolumeOffset[Channel];
                mov     ebx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-8]
                mov     esi,dword [ebx+ecx*4+2099544]
		mov     dword [ebx+ecx*4+2099736],esi
                jmp     NEAR SYNTHASM$241
SYNTHASM$140:
; [267] $92:SynthCalcNote(SynthData,Channel,Volume);
		movzx	eax,byte [ebp-48]
		push	eax
                push    dword ptr [ebp-8]
                mov     eax,dword ptr [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHCALCNOTE$T4KSYNTHDATA$LONGINT$LONGINT
                jmp     NEAR SYNTHASM$241
SYNTHASM$138:
; [266] $91:SynthData.RealTimeData.Phase[Channel]:=Value*2*PI;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                fld     dword ptr [ebp-40]
                fld     tword [SYNTHASM$258]
		fmulp	st1,st0
		fldpi
		fmulp	st1,st0
                fstp    dword ptr [edx+eax*4+2098512]
                jmp     NEAR SYNTHASM$241
SYNTHASM$136:
; [263] SynthData.RealtimeData.Filter[Channel].RHP:=Value;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		imul	eax,40
		mov	esi,dword [ebp-40]
		mov	dword [edx+eax+2098740],esi
; [264] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
                jmp     NEAR SYNTHASM$241
SYNTHASM$134:
; [259] SynthData.RealtimeData.Filter[Channel].RLP:=Value;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		imul	eax,40
		mov     esi,dword [ebp-40]
		mov	dword [edx+eax+2098736],esi
; [260] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
                jmp     NEAR SYNTHASM$241
SYNTHASM$132:
; [255] SynthData.RealtimeData.Filter[Channel].CHP:=Value;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		imul	eax,40
		mov	esi,dword [ebp-40]
		mov	dword [edx+eax+2098732],esi
; [256] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
                jmp     NEAR SYNTHASM$241
SYNTHASM$130:
; [251] SynthData.RealtimeData.Filter[Channel].CLP:=Value;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		imul	eax,40
		mov	esi,dword [ebp-40]
		mov     dword [edx+eax+2098728],esi
; [252] SynthRecalcFilter(SynthData.RealtimeData.Filter[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		imul	eax,40
		lea	eax,[edx+eax+2098704]
		push	eax
		call	NEAR SYNTH_SYNTHRECALCFILTER$T4KFILTER
                jmp     NEAR SYNTHASM$241
SYNTHASM$128:
; [249] $86:SynthData.FileData.Panning[Channel]:=Volume;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		mov     cl,byte [ebp-48]
		mov     byte [edx+eax*1+352],cl
                jmp     NEAR SYNTHASM$241
SYNTHASM$125:
; [245] OscValue:=Volume*PortamentoFactor;
		movzx	eax,byte [ebp-48]
                mov     dword ptr [ebp-56],eax
                fild    dword ptr [ebp-56]
                fld     tword [SYNTHASM$279]
		fmulp	st1,st0
                fstp    dword ptr [ebp-36]
; [246] IF Note=$84 THEN OscValue:=-OscValue;
		movzx	eax,byte [ebp-44]
		cmp	eax,132
                jne     NEAR SYNTHASM$281
                fld     dword ptr [ebp-36]
		fchs
                fstp    dword ptr [ebp-36]
SYNTHASM$281:
; [247] SynthData.RealtimeData.PhaseIncrement[Channel]:=SynthData.RealtimeData.PhaseIncrement[Channel]*(1+OscValue);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                fld     dword ptr [edx+eax*4+2098576]
		fld1
                fadd    dword ptr [ebp-36]
		fmulp	st1,st0
                fstp    dword ptr [edx+eax*4+2098576]
                jmp     NEAR SYNTHASM$241
SYNTHASM$123:
; [243] $83:SynthData.RealtimeData.EventOffset[Channel]:=NIL;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     dword ptr [edx+eax*4+2099416],0
                jmp     NEAR SYNTHASM$241
SYNTHASM$121:
; [242] $82:SynthData.RealtimeData.BPMSamples:=(SampleRate*5*128) DIV (Volume SHL 8);
		movzx	ecx,byte [ebp-48]
		shl	ecx,8
		mov	eax,28224000
		mov	edx,0
		div	ecx
                mov     edx,dword ptr [ebp+8]
                mov     dword ptr [edx+2099800],eax
SYNTHASM$242:
SYNTHASM$241:
SYNTHASM$237:
SYNTHASM$190:
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                cmp     dword ptr [edx+eax*4+2099416],0
                je      NEAR SYNTHASM$191
                mov     ecx,dword ptr [edx+eax*4+2099416]
		movzx	ecx,byte [ecx]
                cmp     ecx,dword ptr [edx+eax*4+2099352]
                jle     NEAR SYNTHASM$189
SYNTHASM$191:
; [276] IF NOT ASSIGNED(SynthData.RealtimeData.EventOffset[Channel]) THEN DEC(Count);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                cmp     dword ptr [edx+eax*4+2099416],0
                jne     NEAR SYNTHASM$292
SYNTHASM$291:
                dec     dword ptr [ebp-12]
SYNTHASM$292:
; [277] INC(SynthData.RealtimeData.TickCounter[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                inc     dword ptr [edx+eax*4+2099352]
SYNTHASM$188:
; [279] Phase:=FRAC(SynthData.RealtimeData.Phase[Channel]+SynthData.RealtimeData.LinkValues[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-8]
                fld     dword ptr [edx+ecx*4+2098000]
                fadd    dword ptr [edx+ecx*4+2098512]
		sub	esp,4
                fstp    dword ptr [esp]
		call	NEAR SYNTH_FRAC$SINGLE
                fstp    dword ptr [ebp-20]
; [280] WaveForm:=SynthData.FileData.WaveForm[Channel];
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		movzx	eax,byte [edx+eax*1]
                mov     dword ptr [ebp-16],eax
; [281] CASE WaveForm OF
		test	eax,eax
                jl      NEAR SYNTHASM$300
		cmp	eax,5
                jg      NEAR SYNTHASM$300
                jmp     [SYNTHASM$301+eax*4]
SYNTHASM$153:
; [290] 5:OscValue:=WhiteNoiseRandom; // White Noise
		call	NEAR SYNTH_WHITENOISERANDOM
                fstp    dword ptr [ebp-36]
                jmp     NEAR SYNTHASM$299
SYNTHASM$150:
; [289] 3,4:OscValue:=((Phase-0.5)*2)*INTEGER(1-((WaveForm-3)*2)); // Sawtooth Up/Down
                mov     eax,dword ptr [ebp-16]
		sub	eax,3
		shl	eax,1
		mov	edx,1
		sub	edx,eax
                mov     dword ptr [ebp-56],edx
                fild    dword ptr [ebp-56]
                fld     dword ptr [ebp-20]
                fld     tword [SYNTHASM$306]
		fsubp	st1,st0
                fld     tword [SYNTHASM$258]
		fmulp	st1,st0
		fmulp	st1,st0
                fstp    dword ptr [ebp-36]
                jmp     NEAR SYNTHASM$299
SYNTHASM$148:
; [285] Phase:=Phase-0.5;
                fld     dword ptr [ebp-20]
                fld     tword [SYNTHASM$306]
		fsubp	st1,st0
                fstp    dword ptr [ebp-20]
; [286] OscValue:=LONGWORD((PhaseCasted SHR 31) SHL 1);
                mov     eax,dword ptr [ebp-20]
		shr	eax,31
		shl	eax,1
                mov     dword ptr [ebp-56],eax
                mov     dword ptr [ebp-64],eax
                mov     dword ptr [ebp-60],0
		fild	qword [ebp-64]
                fstp    dword ptr [ebp-36]
; [287] OscValue:=1-OscValue;
		fld1
                fsub    dword ptr [ebp-36]
                fstp    dword ptr [ebp-36]
                jmp     NEAR SYNTHASM$299
SYNTHASM$146:
; [283] 1:OscValue:=ABS((Phase-0.5)*4)-1; // Triangle
                fld     dword ptr [ebp-20]
                fld     tword [SYNTHASM$306]
		fsubp	st1,st0
                fld     tword [SYNTHASM$315]
		fmulp	st1,st0
		fabs
		fld1
		fsubp	st1,st0
                fstp    dword ptr [ebp-36]
                jmp     NEAR SYNTHASM$299
SYNTHASM$144:
; [282] 0:OscValue:=SIN(Phase*2*PI); // Sinus
                fld     dword ptr [ebp-20]
                fld     tword [SYNTHASM$258]
		fmulp	st1,st0
		fldpi
		fmulp	st1,st0
		fsin
                fstp    dword ptr [ebp-36]
                jmp     NEAR SYNTHASM$299
SYNTHASM$300:
; [291] ELSE OscValue:=0; // Nothing ;-)
		fldz
                fstp    dword ptr [ebp-36]
SYNTHASM$299:
; [293] OscValue:=OscValue*SynthData.RealtimeData.Volume[Channel]*SynthData.RealtimeData.VolumeValue[Channel]*SynthData.RealtimeData.ADSRValue[Channel];
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                fld     dword ptr [ebp-36]
                fmul    dword ptr [edx+eax*4+2098064]
                fmul    dword ptr [edx+eax*4+2098128]
                fmul    dword ptr [edx+eax*4+2098448]
                fstp    dword ptr [ebp-36]
; [294] WITH SynthData.RealtimeData.Filter[Channel] DO BEGIN
		imul	eax,40
		lea	eax,[edx+eax+2098704]
; [295] FD1:=FD1+CLP*(OscValue-FD1+FBLP*(FD1-FD2));
                fld     dword ptr [eax+4]
                fsubr   dword ptr [eax]
                fmul    dword ptr [eax+16]
                fld     dword ptr [ebp-36]
                fsub    dword ptr [eax]
		faddp	st1,st0
                fmul    dword ptr [eax+24]
                fadd    dword ptr [eax]
                fstp    dword ptr [eax]
; [296] FD2:=FD2+CLP*(FD1-FD2);
                fld     dword ptr [eax+4]
                fsubr   dword ptr [eax]
                fmul    dword ptr [eax+24]
                fadd    dword ptr [eax+4]
                fstp    dword ptr [eax+4]
; [297] FD3:=FD3+CHP*(FD2-FD3+FBHP*(FD3-FD4));
                fld     dword ptr [eax+8]
                fsubr   dword ptr [eax+4]
                fld     dword ptr [eax+12]
                fsubr   dword ptr [eax+8]
                fmul    dword ptr [eax+20]
		faddp	st1,st0
                fmul    dword ptr [eax+28]
                fadd    dword ptr [eax+8]
                fstp    dword ptr [eax+8]
; [298] FD4:=FD4+CHP*(FD3-FD4);
                fld     dword ptr [eax+12]
                fsubr   dword ptr [eax+8]
                fmul    dword ptr [eax+28]
                fadd    dword ptr [eax+12]
                fst     dword ptr [eax+12]
; [299] OscValue:=FD2-FD4;
                fsubr   dword ptr [eax+4]
                fstp    dword ptr [ebp-36]
; [301] CASE SynthData.RealtimeData.ADSRMode[Channel] OF
                mov     eax,dword ptr [ebp-8]
                mov     eax,dword ptr [edx+eax*4+2098384]
		test	eax,eax
                jl      NEAR SYNTHASM$335
		cmp	eax,4
                jg      NEAR SYNTHASM$335
                jmp     [SYNTHASM$336+eax*4]
SYNTHASM$163:
; [327] IF SynthData.RealtimeData.ADSRValue[Channel]>0 THEN BEGIN
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                fld     dword ptr [edx+eax*4+2098448]
		fldz
		fcompp
		mov	ecx,eax
		fnstsw	ax
		sahf
                jnb     NEAR SYNTHASM$338
; [328] SynthData.RealtimeData.ADSRValue[Channel]:=SynthData.RealtimeData.ADSRValue[Channel]+SynthData.ADSRData.ReleaseStep[Channel];
                fld     dword ptr [edx+ecx*4+768]
                fadd    dword ptr [edx+ecx*4+2098448]
                fstp    dword ptr [edx+ecx*4+2098448]
                jmp     NEAR SYNTHASM$334
SYNTHASM$338:
; [330] SynthData.RealtimeData.ADSRMode[Channel]:=0;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     dword ptr [edx+eax*4+2098384],0
                jmp     NEAR SYNTHASM$334
SYNTHASM$161:
                jmp     NEAR SYNTHASM$334
SYNTHASM$159:
; [313] IF SynthData.RealtimeData.ADSRValue[Channel]>SynthData.ADSRData.DestDecay[Channel] THEN BEGIN
                mov     edx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-8]
                fld     dword ptr [edx+ecx*4+688]
                fld     dword ptr [edx+ecx*4+2098448]
		fcompp
		fnstsw	ax
		sahf
                jna     NEAR SYNTHASM$345
; [314] SynthData.RealtimeData.ADSRValue[Channel]:=SynthData.RealtimeData.ADSRValue[Channel]+SynthData.ADSRData.DecayStep[Channel];
                fld     dword ptr [edx+ecx*4+624]
                fadd    dword ptr [edx+ecx*4+2098448]
                fstp    dword ptr [edx+ecx*4+2098448]
                jmp     NEAR SYNTHASM$334
SYNTHASM$345:
; [316] SynthData.RealtimeData.ADSRValue[Channel]:=SynthData.ADSRData.DestDecay[Channel];
                mov     ebx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-8]
		mov	esi,dword [ebx+ecx*4+688]
		mov     dword [ebx+ecx*4+2098448],esi
; [317] IF SynthData.ADSRData.Sustain[Channel] THEN BEGIN
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		cmp	byte [edx+eax*1+752],0
                je      NEAR SYNTHASM$352
; [318] SynthData.RealtimeData.ADSRMode[Channel]:=3;
                mov     dword ptr [edx+eax*4+2098384],3
                jmp     NEAR SYNTHASM$334
SYNTHASM$352:
; [320] SynthData.RealtimeData.ADSRMode[Channel]:=4;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     dword ptr [edx+eax*4+2098384],4
                jmp     NEAR SYNTHASM$334
SYNTHASM$157:
; [305] IF SynthData.RealtimeData.ADSRValue[Channel]<1 THEN BEGIN
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                fld     dword ptr [edx+eax*4+2098448]
		fld1
		fcompp
		mov	ebx,eax
		fnstsw	ax
		sahf
                jna     NEAR SYNTHASM$359
; [306] SynthData.RealtimeData.ADSRValue[Channel]:=SynthData.RealtimeData.ADSRValue[Channel]+SynthData.ADSRData.AttackStep[Channel];
                fld     dword ptr [edx+ebx*4+560]
                fadd    dword ptr [edx+ebx*4+2098448]
                fstp    dword ptr [edx+ebx*4+2098448]
                jmp     NEAR SYNTHASM$334
SYNTHASM$359:
; [308] SynthData.RealtimeData.ADSRValue[Channel]:=1;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		fld1
                fstp    dword ptr [edx+eax*4+2098448]
; [309] SynthData.RealtimeData.ADSRMode[Channel]:=2;
                mov     dword ptr [edx+eax*4+2098384],2
SYNTHASM$155:
SYNTHASM$335:
SYNTHASM$334:
; [334] IF SynthData.RealtimeData.ADSRValue[Channel]<0 THEN SynthData.RealtimeData.ADSRValue[Channel]:=0;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                fld     dword ptr [edx+eax*4+2098448]
		fldz
		fcompp
		fnstsw	ax
		sahf
                jna     NEAR SYNTHASM$368
                mov     eax,dword ptr [ebp-8]
		fldz
                fstp    dword ptr [edx+eax*4+2098448]
SYNTHASM$368:
; [335] IF SynthData.RealtimeData.ADSRValue[Channel]>1 THEN SynthData.RealtimeData.ADSRValue[Channel]:=1;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                fld     dword ptr [edx+eax*4+2098448]
		fld1
		fcompp
		fnstsw	ax
		sahf
                jnb     NEAR SYNTHASM$372
                mov     eax,dword ptr [ebp-8]
		fld1
                fstp    dword ptr [edx+eax*4+2098448]
SYNTHASM$372:
; [336] IF (SynthData.FileData.Link[Channel] AND $7F)<Max4kChannels THEN BEGIN
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     eax,dword ptr [edx+eax*1+16]
		and	eax,127
		cmp	eax,16
                jnl     NEAR SYNTHASM$376
; [337] IF SynthData.RealtimeData.LinkFirst[SynthData.FileData.Link[Channel] AND $7F] THEN BEGIN
                mov     eax,dword ptr [ebp-8]
                mov     eax,dword ptr [edx+eax*1+16]
		and	eax,127
		cmp	byte [edx+eax*1+2097984],0
                je      NEAR SYNTHASM$378
; [338] SynthData.RealtimeData.LinkValues[SynthData.FileData.Link[Channel] AND $7F]:=0;
                mov     eax,dword ptr [ebp-8]
                mov     eax,dword ptr [edx+eax*1+16]
		and	eax,127
		fldz
                fstp    dword ptr [edx+eax*4+2098000]
; [339] SynthData.RealtimeData.LinkFirst[SynthData.FileData.Link[Channel] AND $7F]:=FALSE;
                mov     eax,dword ptr [ebp-8]
                mov     eax,dword ptr [edx+eax*1+16]
		and	eax,127
		mov	byte [edx+eax*1+2097984],0
SYNTHASM$378:
; [341] SynthData.RealtimeData.LinkValues[SynthData.FileData.Link[Channel] AND $7F]:=SynthData.RealtimeData.LinkValues[SynthData.FileData.Link[Channel] AND $7F]+(OscValue*SynthData.FileData.LinkFactor[Channel]);
                mov     ecx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     edx,dword ptr [ecx+eax*1+16]
		and	edx,127
                fld     dword ptr [ebp-36]
                fmul    dword ptr [ecx+eax*4+32]
                fadd    dword ptr [ecx+edx*4+2098000]
                mov     edx,dword ptr [ecx+eax*1+16]
		and	edx,127
                fstp    dword ptr [ecx+edx*4+2098000]
SYNTHASM$376:
; [343] IF (SynthData.FileData.Link[Channel] AND $80)<>0 THEN BEGIN
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                mov     eax,dword ptr [edx+eax*1+16]
		and	eax,128
                je      NEAR SYNTHASM$386
; [344] Value:=OscValue*SynthData.FileData.OutFactor[Channel];
                mov     eax,dword ptr [ebp-8]
                fld     dword ptr [ebp-36]
                fmul    dword ptr [edx+eax*4+96]
                fstp    dword ptr [ebp-40]
; [345] PanningValue:=SynthData.FileData.Panning[Channel]*Div255;
		movzx	eax,byte [edx+eax*1+352]
                mov     dword ptr [ebp-56],eax
                fild    dword ptr [ebp-56]
                fld     tword [SYNTHASM$391]
		fmulp	st1,st0
                fst     dword ptr [ebp-32]
; [349] OscValue:=Value*PanningValue;
                fmul    dword ptr [ebp-40]
                fstp    dword ptr [ebp-36]
; [350] SynthData.RealtimeData.ChannelLastLeft[Channel]:=OscValue;
                mov     eax,dword ptr [ebp-8]
		mov	esi,dword [ebp-36]
		mov	dword [edx+eax*4+2098256],esi
; [351] Left:=Left+OscValue;
                fld     dword ptr [ebp-36]
                fadd    dword ptr [ebp-24]
                fstp    dword ptr [ebp-24]
; [352] OscValue:=Value*(1-PanningValue);
                fld     dword ptr [ebp-40]
		fld1
                fsub    dword ptr [ebp-32]
		fmulp	st1,st0
                fstp    dword ptr [ebp-36]
; [353] SynthData.RealtimeData.ChannelLastRight[Channel]:=OscValue;
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
		mov	esi,dword [ebp-36]
		mov     dword [edx+eax*4+2098320],esi
; [354] Right:=Right+OscValue;
                fld     dword ptr [ebp-36]
                fadd    dword ptr [ebp-28]
                fstp    dword ptr [ebp-28]
SYNTHASM$386:
; [360] SynthData.RealtimeData.Phase[Channel]:=FRAC(SynthData.RealtimeData.Phase[Channel]+SynthData.RealtimeData.PhaseIncrement[Channel]);
                mov     edx,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp-8]
                fld     dword ptr [edx+ecx*4+2098576]
                fadd    dword ptr [edx+ecx*4+2098512]
		sub	esp,4
                fstp    dword ptr [esp]
		call	NEAR SYNTH_FRAC$SINGLE
                mov     edx,dword ptr [ebp+8]
                mov     eax,dword ptr [ebp-8]
                fstp    dword ptr [edx+eax*4+2098512]
; [361] SynthData.RealtimeData.PhaseIncrement[Channel]:=SynthData.RealtimeData.PhaseIncrement[Channel]*SynthData.RealtimeData.PhaseFactor[Channel];
                fld     dword ptr [edx+eax*4+2098640]
                fmul    dword ptr [edx+eax*4+2098576]
                fstp    dword ptr [edx+eax*4+2098576]
; [362] SynthData.RealtimeData.Volume[Channel]:=SynthData.RealtimeData.Volume[Channel]*SynthData.RealtimeData.VolumeFactor[Channel];
                fld     dword ptr [edx+eax*4+2098192]
                fmul    dword ptr [edx+eax*4+2098064]
                fstp    dword ptr [edx+eax*4+2098064]
		cmp	eax,15
                jl      NEAR SYNTHASM$184
; [364] IF SynthData.RealtimeData.CurrentBPMSamples=0 THEN BEGIN
                mov     eax,dword ptr [edx+2099804]
		test	eax,eax
                jne     NEAR SYNTHASM$413
; [365] IF Count=0 THEN SynthReinit(SynthData);
                mov     eax,dword ptr [ebp-12]
		test	eax,eax
                jne     NEAR SYNTHASM$415
		mov	eax,edx
		push	eax
		call	NEAR SYNTH_SYNTHREINIT$T4KSYNTHDATA
SYNTHASM$415:
; [366] SynthData.RealtimeData.CurrentBPMSamples:=SynthData.RealtimeData.BPMSamples;
                mov     edx,dword ptr [ebp+8]
		mov	esi,dword [edx+2099800]
		mov	dword [edx+2099804],esi
SYNTHASM$413:
; [368] DEC(SynthData.RealtimeData.CurrentBPMSamples);
                mov     eax,dword ptr [ebp+8]
                dec     dword ptr [eax+2099804]
; [369] Left:=Left+SynthData.RealtimeData.LastLeft;
                fld     dword ptr [ebp-24]
                fadd    dword ptr [eax+2099344]
                fstp    dword ptr [ebp-24]
; [370] SynthData.RealtimeData.LastLeft:=SynthData.RealtimeData.LastLeft*0.9;
                fld     dword ptr [eax+2099344]
                fld     tword [SYNTHASM$424]
		fmulp	st1,st0
                fstp    dword ptr [eax+2099344]
; [371] Right:=Right+SynthData.RealtimeData.LastRight;
                fld     dword ptr [ebp-28]
                fadd    dword ptr [eax+2099348]
                fstp    dword ptr [ebp-28]
; [372] SynthData.RealtimeData.LastRight:=SynthData.RealtimeData.LastRight*0.9;
                fld     dword ptr [eax+2099348]
                fld     tword [SYNTHASM$424]
		fmulp	st1,st0
                fstp    dword ptr [eax+2099348]
; [373] Buffer^:=Left*Div8;
                mov     eax,dword ptr [ebp+12]
                fld     dword ptr [ebp-24]
                fld     tword [SYNTHASM$431]
		fmulp	st1,st0
                fstp    dword ptr [eax]
; [374] INC(Buffer);
                add     dword ptr [ebp+12],4
; [375] Buffer^:=Right*Div8;
                mov     eax,dword ptr [ebp+12]
                fld     dword ptr [ebp-28]
                fld     tword [SYNTHASM$431]
		fmulp	st1,st0
                fstp    dword ptr [eax]
; [376] INC(Buffer);
                add     dword ptr [ebp+12],4
                mov     eax,dword ptr [ebp-4]
                cmp     eax,dword ptr [ebp-52]
                jl      NEAR SYNTHASM$167
SYNTHASM$166:
; [378] END;
                mov     ebx,dword ptr [ebp-76]
                mov     esi,dword ptr [ebp-72]
                mov     edi,dword ptr [ebp-68]
		leave
		ret	16

SYNTH_SYNTHLOAD$T4KSYNTHDATA$POINTER$LONGINT:
SynthLoad:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para SynthData located at ebp+8
; Para TrackData located at ebp+12
; Para TrackSize located at ebp+16
; [382] FILLCHAR(SynthData,SIZEOF(T4kSynthData),#0);
                xor     eax,eax
                mov     ecx,2099809
                mov     esi,dword ptr [ebp+8]
                rep     stosb
; [383] MOVE(TrackData^,SynthData,TrackSize);
                mov     esi,dword ptr [ebp+12]
                mov     edi,dword ptr [ebp+8]
                mov     ecx,dword ptr [ebp+16]
                rep     movsb
; [384] SynthInitData(SynthData);
                mov     eax,dword ptr [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHINITDATA$T4KSYNTHDATA
; [385] END;
		leave
		ret	12

SYNTH_SYNTHINIT$T4KSYNTHDATA$POINTER$LONGINT:
SynthInit:
; Temps allocated between ebp-4 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,4
; Para SynthData located at ebp+8
; Para TrackData located at ebp+12
; Para TrackSize located at ebp+16
; Local I located at ebp-4
; [392] FLDCW cwChop
		fldcw	word [TC_SYNTH_SYNTHINIT$_CWCHOP]
; [394] SynthLoad(SynthData,TrackData,TrackSize);
                push    dword ptr [ebp+16]
                push    dword ptr [ebp+12]
                mov     eax,dword ptr [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHLOAD$T4KSYNTHDATA$POINTER$LONGINT
; [396] WhiteNoiseSeed:=$12345678;
                mov     dword ptr [U_SYNTH_WHITENOISESEED],305419896
; [398] waveOutOpen(@WaveOutHandle,WAVE_MAPPER,@WaveFormat,0,0,0);
		push	dword 0
		push	dword 0
		push	dword 0
		mov	eax,dword TC_SYNTH_WAVEFORMAT
		push	eax
		push	dword -1
		mov	eax,dword U_SYNTH_WAVEOUTHANDLE
		push	eax
                INVOKE  waveOutOpen    
; [400] FOR I:=0 TO 3 DO BEGIN
                mov     dword ptr [ebp-4],0
                dec     dword ptr [ebp-4]
SYNTHASM$474:
                inc     dword ptr [ebp-4]
; [401] WaveHandler[I].dwFlags:=WHDR_DONE;
                mov     eax,dword ptr [ebp-4]
		shl	eax,5
                mov     dword ptr [U_SYNTH_WAVEHANDLER+eax+16],1
; [402] WaveHandler[I].lpData:=@Buffers[I];
                mov     eax,dword ptr [ebp-4]
		imul	eax,32776
		lea	edx,[U_SYNTH_BUFFERS+eax]
                mov     eax,dword ptr [ebp-4]
		shl	eax,5
                mov     dword ptr [U_SYNTH_WAVEHANDLER+eax],edx
; [403] WaveHandler[I].dwBufferLength:=BufferSize*8;
                mov     dword ptr [U_SYNTH_WAVEHANDLER+eax+4],32768
                cmp     dword ptr [ebp-4],3
                jl      NEAR SYNTHASM$474
; [406] BufferCounter:=0;
                mov     dword ptr [U_SYNTH_BUFFERCOUNTER],0
; [407] END;
		leave
		ret	12

SYNTH_SYNTHPOLL$T4KSYNTHDATA:
SynthPoll:
; Temps allocated between ebp+0 and ebp+0
		push	ebp
		mov	ebp,esp
; Para SynthData located at ebp+8
; [411] IF (WaveHandler[BufferCounter].dwFlags AND WHDR_DONE)<>0 THEN BEGIN
                mov     eax,dword ptr [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
                mov     eax,dword ptr [U_SYNTH_WAVEHANDLER+eax+16]
		and	eax,1
                je      NEAR SYNTHASM$488
; [412] IF waveOutUnprepareHeader(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR))<>WAVERR_STILLPLAYING THEN BEGIN
		push	dword 32
                mov     eax,dword ptr [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
                push    dword ptr [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutUnprepareHeader
		cmp	eax,33
                je      NEAR SYNTHASM$490
; [413] WaveHandler[BufferCounter].dwFlags:=WaveHandler[BufferCounter].dwFlags AND NOT WHDR_DONE;
                mov     eax,dword ptr [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
                and     dword ptr [U_SYNTH_WAVEHANDLER+eax+16],-2
; [414] SynthFillBuffer(SynthData,@WaveHandler[BufferCounter].lpData^,0,BufferSize);
		push	dword 4096
		push	dword 0
                mov     eax,dword ptr [U_SYNTH_WAVEHANDLER+eax]
		push	eax
                mov     eax,dword ptr [ebp+8]
		push	eax
		call	NEAR SYNTH_SYNTHFILLBUFFER$T4KSYNTHDATA$PSINGLE$LONGINT$LONGINT
; [415] waveOutPrepareHeader(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR));
		push	dword 32
                mov     eax,dword ptr [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
                push    dword ptr [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutPrepareHeader
; [416] waveOutWrite(WaveOutHandle,@WaveHandler[BufferCounter],SIZEOF(TWAVEHDR));
		push	dword 32
                mov     eax,dword ptr [U_SYNTH_BUFFERCOUNTER]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
                push    dword ptr [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutWrite
; [417] BufferCounter:=(BufferCounter+1) MOD 4;
                mov     eax,dword ptr [U_SYNTH_BUFFERCOUNTER]
		inc	eax
		and	eax,3
                mov     dword ptr [U_SYNTH_BUFFERCOUNTER],eax
SYNTHASM$490:
SYNTHASM$488:
; [420] END;
		leave
		ret	4

SYNTH_SYNTHDONE$T4KSYNTHDATA:
.SMARTLINK SynthDone {
 .IF(Synthclean){
; Temps allocated between ebp-4 and ebp-4
		push	ebp
		mov	ebp,esp
		sub	esp,4
; Para SynthData located at ebp+8
; Local I located at ebp-4
; [428] FOR I:=0 TO 3 DO BEGIN
                mov     dword ptr [ebp-4],0
                dec     dword ptr [ebp-4]
SYNTHASM$525:
                inc     dword ptr [ebp-4]
SYNTHASM$528:
SYNTHASM$529:
; [429] WHILE waveOutUnprepareHeader(WaveOutHandle,@WaveHandler[I],SIZEOF(TWAVEHDR))=WAVERR_STILLPLAYING DO BEGIN
		push	dword 32
                mov     eax,dword ptr [ebp-4]
		shl	eax,5
		lea	eax,[U_SYNTH_WAVEHANDLER+eax]
		push	eax
                push    dword ptr [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutUnprepareHeader
		cmp	eax,33
                je      NEAR SYNTHASM$528
SYNTHASM$530:
                cmp     dword ptr [ebp-4],3
                jl      NEAR SYNTHASM$525
; [432] waveOutReset(WaveOutHandle);
                push    dword ptr [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutReset
; [433] waveOutClose(WaveOutHandle);
                push    dword ptr [U_SYNTH_WAVEOUTHANDLE]
                INVOKE  waveOutClose
; [435] END;
		leave
		ret	4
 } else {
                ret     
 }
}
; [116] CONST WaveFormat:TWaveFormatEx=(wFormatTag:3;nChannels:2;nSamplesPerSec:SampleRate;
TC_SYNTH_WAVEFORMAT:
        DW      3,2
	DD	44100,352800
	DW	8,32,0
SYNTHASM$243:
                DD      SYNTHASM$121
                DD      SYNTHASM$123
                DD      SYNTHASM$125
                DD      SYNTHASM$125
                DD      SYNTHASM$128
                DD      SYNTHASM$130
                DD      SYNTHASM$132
                DD      SYNTHASM$134
                DD      SYNTHASM$242
                DD      SYNTHASM$242
                DD      SYNTHASM$242
                DD      SYNTHASM$242
                DD      SYNTHASM$242
                DD      SYNTHASM$242
                DD      SYNTHASM$136
                DD      SYNTHASM$138
                DD      SYNTHASM$140
                DD      SYNTHASM$142
SYNTHASM$301:
                DD      SYNTHASM$144
                DD      SYNTHASM$146
                DD      SYNTHASM$148
                DD      SYNTHASM$150
                DD      SYNTHASM$150
                DD      SYNTHASM$153
SYNTHASM$336:
                DD      SYNTHASM$155
                DD      SYNTHASM$157
                DD      SYNTHASM$159
                DD      SYNTHASM$161
                DD      SYNTHASM$163

; [388] CONST cwChop:WORD=$F7B;
TC_SYNTH_SYNTHINIT$_CWCHOP:      DW      3963
; [438] 

SYNTHASM$54:
                DEF       3.0000000000000000e0000
SYNTHASM$101:
                DSF       9.960937500e-01
SYNTHASM$114:
                DEF       8.3333333333333333e-0002
SYNTHASM$117:
                DSF       2.000000000e00
SYNTHASM$118:
                DEF       9.9773242630385488e-0003
SYNTHASM$236:
                DEF       1.5625000000000000e-0002
SYNTHASM$240:
                DEF       3.9062500000000000e-0003
SYNTHASM$258:
                DEF       2.0000000000000000e0000
SYNTHASM$279:
                DEF       6.2358276643990930e-0004
SYNTHASM$306:
                DEF       5.0000000000000000e-0001
SYNTHASM$315:
                DEF       4.0000000000000000e0000
SYNTHASM$391:
                DEF       3.9215686274509804e-0003
SYNTHASM$424:
                DEF       9.0000000000000000e-0001
SYNTHASM$431:
                DEF       1.2500000000000000e-0001


